/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider.mappersync;

import java.util.function.Consumer;
import org.keycloak.broker.provider.mappersync.AbstractConfigPropertySynchronizer;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class GroupConfigPropertyByPathSynchronizer
extends AbstractConfigPropertySynchronizer<GroupModel.GroupPathChangeEvent> {
    public static final GroupConfigPropertyByPathSynchronizer INSTANCE = new GroupConfigPropertyByPathSynchronizer();

    private GroupConfigPropertyByPathSynchronizer() {
    }

    @Override
    public Class<GroupModel.GroupPathChangeEvent> getEventClass() {
        return GroupModel.GroupPathChangeEvent.class;
    }

    @Override
    public RealmModel extractRealm(GroupModel.GroupPathChangeEvent event) {
        return event.getRealm();
    }

    @Override
    public String getConfigPropertyName() {
        return "group";
    }

    @Override
    protected void updateConfigPropertyIfNecessary(GroupModel.GroupPathChangeEvent event, String currentPropertyValue, Consumer<String> propertyUpdater) {
        String previousGroupPath;
        String configuredGroupPath = KeycloakModelUtils.normalizeGroupPath(currentPropertyValue);
        if (configuredGroupPath.equals(previousGroupPath = event.getPreviousPath())) {
            String newPath = event.getNewPath();
            propertyUpdater.accept(newPath);
        } else if (GroupConfigPropertyByPathSynchronizer.isSubGroupOf(configuredGroupPath, previousGroupPath)) {
            String newPath = event.getNewPath() + configuredGroupPath.substring(previousGroupPath.length());
            propertyUpdater.accept(newPath);
        }
    }

    private static boolean isSubGroupOf(String groupPath, String potentialParentGroupPath) {
        return groupPath.startsWith(potentialParentGroupPath + "/");
    }
}

