/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import org.hibernate.HibernateException;
import org.hibernate.SharedSessionContract;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.internal.BinaryStreamImpl;
import org.hibernate.internal.util.SerializationHelper;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractArrayJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.ShortJavaType;

public class ShortPrimitiveArrayJavaType
extends AbstractArrayJavaType<short[], Short> {
    public static final ShortPrimitiveArrayJavaType INSTANCE = new ShortPrimitiveArrayJavaType();

    private ShortPrimitiveArrayJavaType() {
        this(ShortJavaType.INSTANCE);
    }

    protected ShortPrimitiveArrayJavaType(JavaType<Short> baseDescriptor) {
        super(short[].class, baseDescriptor, new ArrayMutabilityPlan());
    }

    @Override
    public String extractLoggableRepresentation(short[] value) {
        return value == null ? super.extractLoggableRepresentation(null) : Arrays.toString(value);
    }

    @Override
    public boolean areEqual(short[] one, short[] another) {
        return Arrays.equals(one, another);
    }

    @Override
    public int extractHashCode(short[] value) {
        return Arrays.hashCode(value);
    }

    @Override
    public String toString(short[] value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append(value[0]);
        for (int i = 1; i < value.length; ++i) {
            sb.append(value[i]);
            sb.append(',');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public short[] fromString(CharSequence charSequence) {
        int elementStart;
        if (charSequence == null) {
            return null;
        }
        ArrayList<Short> list = new ArrayList<Short>();
        char lastChar = charSequence.charAt(charSequence.length() - 1);
        char firstChar = charSequence.charAt(0);
        if (firstChar != '{' || lastChar != '}') {
            throw new IllegalArgumentException("Cannot parse given string into array of strings. First and last character must be { and }");
        }
        int len = charSequence.length();
        for (int i = elementStart = 1; i < len; ++i) {
            char c = charSequence.charAt(i);
            if (c != ',') continue;
            list.add(Short.parseShort(charSequence.subSequence(elementStart, i).toString(), 10));
            elementStart = i + 1;
        }
        short[] result = new short[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Short)list.get(i);
        }
        return result;
    }

    @Override
    public <X> X unwrap(short[] value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return (X)value;
        }
        if (Object[].class.isAssignableFrom(type)) {
            Class<?> preferredJavaTypeClass = type.getComponentType();
            Object[] unwrapped = (Object[])Array.newInstance(preferredJavaTypeClass, value.length);
            for (int i = 0; i < value.length; ++i) {
                unwrapped[i] = this.getElementJavaType().unwrap(value[i], preferredJavaTypeClass, options);
            }
            return (X)unwrapped;
        }
        if (type == byte[].class) {
            return (X)SerializationHelper.serialize((Serializable)value);
        }
        if (type == BinaryStream.class) {
            return (X)new BinaryStreamImpl(SerializationHelper.serialize((Serializable)value));
        }
        if (type.isArray()) {
            Class<?> preferredJavaTypeClass = type.getComponentType();
            Object unwrapped = Array.newInstance(preferredJavaTypeClass, value.length);
            for (int i = 0; i < value.length; ++i) {
                Array.set(unwrapped, i, this.getElementJavaType().unwrap(value[i], preferredJavaTypeClass, options));
            }
            return (X)unwrapped;
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> short[] wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof java.sql.Array) {
            try {
                value = ((java.sql.Array)value).getArray();
            }
            catch (SQLException ex) {
                throw new HibernateException(ex);
            }
        }
        if (value instanceof short[]) {
            return (short[])value;
        }
        if (value instanceof byte[]) {
            return (short[])SerializationHelper.deserialize((byte[])value);
        }
        if (value instanceof BinaryStream) {
            return (short[])SerializationHelper.deserialize(((BinaryStream)value).getBytes());
        }
        if (value.getClass().isArray()) {
            short[] wrapped = new short[Array.getLength(value)];
            for (int i = 0; i < wrapped.length; ++i) {
                wrapped[i] = (Short)this.getElementJavaType().wrap(Array.get(value, i), options);
            }
            return wrapped;
        }
        throw this.unknownWrap(value.getClass());
    }

    private static class ArrayMutabilityPlan
    implements MutabilityPlan<short[]> {
        private ArrayMutabilityPlan() {
        }

        @Override
        public boolean isMutable() {
            return true;
        }

        @Override
        public short[] deepCopy(short[] value) {
            return value == null ? null : (short[])value.clone();
        }

        @Override
        public Serializable disassemble(short[] value, SharedSessionContract session) {
            return this.deepCopy(value);
        }

        @Override
        public short[] assemble(Serializable cached, SharedSessionContract session) {
            return this.deepCopy((short[])cached);
        }
    }
}

