/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmCacheInvalidationEvent;
import org.keycloak.models.sessions.infinispan.util.KeycloakMarshallUtil;

@SerializeWith(value=ExternalizerImpl.class)
public class ClientRemovedEvent
extends InvalidationEvent
implements RealmCacheInvalidationEvent {
    private String clientUuid;
    private String clientId;
    private String realmId;
    private Map<String, String> clientRoles;
    private static final Logger log = Logger.getLogger(ClientRemovedEvent.class);

    public static ClientRemovedEvent create(ClientModel client) {
        log.tracev("Created; clientId={0}", (Object)client.getClientId());
        ClientRemovedEvent event = new ClientRemovedEvent();
        event.realmId = client.getRealm().getId();
        event.clientUuid = client.getId();
        event.clientId = client.getClientId();
        event.clientRoles = client.getRolesStream().collect(Collectors.toMap(RoleModel::getId, RoleModel::getName));
        return event;
    }

    protected void finalize() throws Throwable {
        log.tracev("Finalized; clientId={0}", (Object)this.clientId);
        super.finalize();
    }

    @Override
    public String getId() {
        return this.clientUuid;
    }

    public String toString() {
        return String.format("ClientRemovedEvent [ realmId=%s, clientUuid=%s, clientId=%s, clientRoleIds=%s ]", this.realmId, this.clientUuid, this.clientId, this.clientRoles);
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
        realmCache.clientRemoval(this.realmId, this.clientUuid, this.clientId, invalidations);
        for (Map.Entry<String, String> clientRole : this.clientRoles.entrySet()) {
            String roleId = clientRole.getKey();
            String roleName = clientRole.getValue();
            realmCache.roleRemoval(roleId, roleName, this.clientUuid, invalidations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientRemovedEvent that = (ClientRemovedEvent)o;
        boolean equals = Objects.equals(this.clientUuid, that.clientUuid) && Objects.equals(this.clientId, that.clientId) && Objects.equals(this.realmId, that.realmId) && Objects.equals(this.clientRoles, that.clientRoles);
        log.tracev("Equals; clientId={0}, equals={1}", (Object)this.clientId, (Object)equals);
        return equals;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.clientUuid, this.clientId, this.realmId, this.clientRoles);
    }

    public static class ExternalizerImpl
    implements Externalizer<ClientRemovedEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, ClientRemovedEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.clientUuid, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.clientId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.realmId, (ObjectOutput)output);
            KeycloakMarshallUtil.writeMap(obj.clientRoles, KeycloakMarshallUtil.STRING_EXT, KeycloakMarshallUtil.STRING_EXT, output);
            log.tracev("Write; clientId={0}", (Object)obj.clientId);
        }

        public ClientRemovedEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public ClientRemovedEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            ClientRemovedEvent res = new ClientRemovedEvent();
            res.clientUuid = MarshallUtil.unmarshallString((ObjectInput)input);
            res.clientId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.realmId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.clientRoles = KeycloakMarshallUtil.readMap(input, KeycloakMarshallUtil.STRING_EXT, KeycloakMarshallUtil.STRING_EXT, size -> new ConcurrentHashMap(size));
            log.tracev("Read; clientId={0}", (Object)res.clientId);
            return res;
        }
    }
}

