/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.endpoints.request.AuthzEndpointRequestParser;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.services.Urls;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.AuthorizationRequestContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class SecureRequestObjectExecutor
implements ClientPolicyExecutorProvider<Configuration> {
    private static final Logger logger = Logger.getLogger(SecureRequestObjectExecutor.class);
    public static final Integer DEFAULT_AVAILABLE_PERIOD = 3600;
    private final KeycloakSession session;
    private Configuration configuration;

    public SecureRequestObjectExecutor(KeycloakSession session) {
        this.session = session;
    }

    public void setupConfiguration(Configuration config) {
        if (config == null) {
            this.configuration = new Configuration();
            this.configuration.setVerifyNbf(Boolean.TRUE);
            this.configuration.setAvailablePeriod(DEFAULT_AVAILABLE_PERIOD);
            this.configuration.setEncryptionRequired(Boolean.FALSE);
        } else {
            this.configuration = config;
            if (config.isVerifyNbf() == null) {
                this.configuration.setVerifyNbf(Boolean.TRUE);
            }
            if (config.getAvailablePeriod() == null) {
                this.configuration.setAvailablePeriod(DEFAULT_AVAILABLE_PERIOD);
            }
            if (config.isEncryptionRequired() == null) {
                this.configuration.setEncryptionRequired(Boolean.FALSE);
            }
        }
    }

    public Class<Configuration> getExecutorConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "secure-request-object";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case AUTHORIZATION_REQUEST: {
                AuthorizationRequestContext authorizationRequestContext = (AuthorizationRequestContext)context;
                this.executeOnAuthorizationRequest(authorizationRequestContext);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void executeOnAuthorizationRequest(AuthorizationRequestContext context) throws ClientPolicyException {
        Boolean encryptionRequired;
        Optional<String> incorrectParam;
        String iss;
        JsonNode requestObject;
        logger.trace((Object)"Authz Endpoint - authz request");
        MultivaluedMap<String, String> params = context.getRequestParameters();
        if (params == null) {
            logger.trace((Object)"request parameter not exist.");
            this.throwClientPolicyException("invalid_request", "Missing parameters", context);
        }
        String requestParam = (String)params.getFirst((Object)"request");
        String requestUriParam = (String)params.getFirst((Object)"request_uri");
        if (requestParam == null && requestUriParam == null) {
            logger.trace((Object)"request object not exist.");
            this.throwClientPolicyException("invalid_request", "Missing parameter: 'request' or 'request_uri'", context);
        }
        if ((requestObject = (JsonNode)this.session.getAttribute("ParsedRequestObject")) == null || requestObject.isEmpty()) {
            logger.trace((Object)"request object not exist.");
            this.throwClientPolicyException("invalid_request", "Invalid parameter: : 'request' or 'request_uri'", context);
        }
        if (params.getFirst((Object)"scope") == null && requestObject.get("scope") == null) {
            logger.trace((Object)"scope object not exist.");
            this.throwClientPolicyException("invalid_request", "Parameter 'scope' missing in the request parameters or in 'request' object", context);
        }
        if (requestObject.get("exp") == null) {
            logger.trace((Object)"exp claim not incuded.");
            this.throwClientPolicyException("invalid_request_object", "Missing parameter in the 'request' object: exp", context);
        }
        long exp = requestObject.get("exp").asLong();
        if ((long)Time.currentTime() > exp) {
            logger.trace((Object)"request object expired.");
            throw new ClientPolicyException("invalid_request_object", "Request Expired");
        }
        if (Optional.ofNullable(this.configuration.isVerifyNbf()).orElse(Boolean.FALSE).booleanValue()) {
            int availablePeriod;
            if (requestObject.get("nbf") == null) {
                logger.trace((Object)"nbf claim not incuded.");
                this.throwClientPolicyException("invalid_request_object", "Missing parameter in the 'request' object: nbf", context);
            }
            long nbf = requestObject.get("nbf").asLong();
            if ((long)Time.currentTime() < nbf) {
                logger.trace((Object)"request object not yet being processed.");
                this.throwClientPolicyException("invalid_request_object", "Request not yet being processed", context);
            }
            if (exp - nbf > (long)(availablePeriod = Optional.ofNullable(this.configuration.getAvailablePeriod()).orElse(DEFAULT_AVAILABLE_PERIOD).intValue())) {
                logger.trace((Object)"request object's available period is long.");
                this.throwClientPolicyException("invalid_request_object", "Request's available period is long", context);
            }
        }
        ArrayList<String> aud = new ArrayList<String>();
        JsonNode audience = requestObject.get("aud");
        if (audience == null) {
            logger.trace((Object)"aud claim not incuded.");
            this.throwClientPolicyException("invalid_request_object", "Missing parameter in the 'request' object: aud", context);
        }
        if (audience.isArray()) {
            for (JsonNode node : audience) {
                aud.add(node.asText());
            }
        } else {
            aud.add(audience.asText());
        }
        if (aud.isEmpty()) {
            logger.trace((Object)"aud claim not incuded.");
            this.throwClientPolicyException("invalid_request_object", "Missing parameter value in the 'request' object: aud", context);
        }
        if (!aud.contains(iss = Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.session.getContext().getRealm().getName()))) {
            logger.trace((Object)"aud not points to the intended realm.");
            this.throwClientPolicyException("invalid_request_object", "Invalid parameter in the 'request' object: aud", context);
        }
        if ((incorrectParam = AuthzEndpointRequestParser.KNOWN_REQ_PARAMS.stream().filter(param -> params.containsKey(param)).filter(param -> !this.isSameParameterIncluded((String)param, (String)params.getFirst(param), requestObject)).findFirst()).isPresent()) {
            logger.warnf("Parameter '%s' does not have same value in 'request' object and in request parameters", (Object)incorrectParam.get());
            this.throwClientPolicyException("invalid_request", "Invalid parameter. Parameters in 'request' object not matching with request parameters", context);
        }
        if ((encryptionRequired = Optional.ofNullable(this.configuration.isEncryptionRequired()).orElse(Boolean.FALSE)).booleanValue() && this.session.getAttribute("EncryptedRequestObject") == null) {
            logger.trace((Object)"request object's not encrypted.");
            throw new ClientPolicyException("invalid_request_object", "Request object not encrypted");
        }
        logger.trace((Object)"Passed.");
    }

    private boolean isSameParameterIncluded(String param, String value, JsonNode requestObject) {
        if (param.equals("request") || param.equals("request_uri")) {
            return true;
        }
        if (requestObject.hasNonNull(param)) {
            return requestObject.get(param).asText().equals(value);
        }
        return false;
    }

    private void throwClientPolicyException(String error, String message, AuthorizationRequestContext context) throws ClientPolicyException {
        if (context.isParRequest() && "invalid_request_object".equals(error)) {
            throw new ClientPolicyException("invalid_request_uri", message);
        }
        throw new ClientPolicyException(error, message);
    }

    public static class Configuration
    extends ClientPolicyExecutorConfigurationRepresentation {
        @JsonProperty(value="available-period")
        protected Integer availablePeriod;
        @JsonProperty(value="verify-nbf")
        protected Boolean verifyNbf;
        @JsonProperty(value="encryption-required")
        private Boolean encryptionRequired;

        public Integer getAvailablePeriod() {
            return this.availablePeriod;
        }

        public void setAvailablePeriod(Integer availablePeriod) {
            this.availablePeriod = availablePeriod;
        }

        public Boolean isVerifyNbf() {
            return this.verifyNbf;
        }

        public void setVerifyNbf(Boolean verifyNbf) {
            this.verifyNbf = verifyNbf;
        }

        public void setEncryptionRequired(Boolean encryptionRequired) {
            this.encryptionRequired = encryptionRequired;
        }

        public Boolean isEncryptionRequired() {
            return this.encryptionRequired;
        }
    }
}

