/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.tree;

import java.util.HashMap;
import java.util.Map;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.EntityField;
import org.keycloak.models.map.storage.tree.DefaultTreeNode;
import org.keycloak.models.map.storage.tree.TreeStorageNodePrescription;

public class TreeStorageNodeInstance<V extends AbstractEntity>
extends DefaultTreeNode<TreeStorageNodeInstance<V>> {
    private final KeycloakSession session;
    private final TreeStorageNodePrescription prescription;
    private final TreeStorageNodeInstance<V> original;

    public TreeStorageNodeInstance(KeycloakSession session, TreeStorageNodeInstance<V> original) {
        super(original.getNodeProperties(), original.getEdgeProperties(), original.getTreeProperties());
        this.original = original;
        this.prescription = original.prescription;
        this.session = session;
    }

    public TreeStorageNodeInstance(KeycloakSession session, TreeStorageNodePrescription prescription) {
        super(prescription.getNodeProperties() == null ? null : new HashMap<String, Object>(prescription.getNodeProperties()), (Map<String, Object>)(prescription.getEdgeProperties() == null ? null : new HashMap<String, Object>(prescription.getEdgeProperties())), prescription.getTreeProperties());
        this.prescription = prescription;
        this.session = session;
        this.original = null;
    }

    public TreeStorageNodeInstance<V> cloneNodeOnly() {
        return new TreeStorageNodeInstance<V>(this.session, this.original == null ? this : this.original);
    }

    @Override
    public String getId() {
        return this.prescription.getId();
    }

    public boolean isReadOnly() {
        return this.prescription.isReadOnly();
    }

    public TreeStorageNodePrescription.FieldContainedStatus isCacheFor(EntityField<V> field, Object parameter) {
        return this.prescription.isCacheFor(field, parameter);
    }

    public TreeStorageNodePrescription.FieldContainedStatus isPrimarySourceFor(Enum<? extends EntityField<V>> field, Object parameter) {
        return this.prescription.isPrimarySourceFor((EntityField)((Object)field), parameter);
    }

    public static class WithEntity {
        private final V entity;
        final /* synthetic */ TreeStorageNodeInstance this$0;

        public WithEntity(V entity) {
            this.this$0 = this$0;
            this.entity = entity;
        }

        public V getEntity() {
            return this.entity;
        }

        public TreeStorageNodeInstance<V> getNode() {
            return this.this$0;
        }
    }
}

