/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.entities;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.jboss.logging.Logger;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.util.KeycloakMarshallUtil;

@SerializeWith(value=ExternalizerImpl.class)
public class AuthenticatedClientSessionEntity
extends SessionEntity {
    public static final Logger logger = Logger.getLogger(AuthenticatedClientSessionEntity.class);
    public static final String LAST_TIMESTAMP_REMOTE = "lstr";
    public static final String CLIENT_ID_NOTE = "clientId";
    private String authMethod;
    private String redirectUri;
    private volatile int timestamp;
    private String action;
    private Map<String, String> notes = new ConcurrentHashMap<String, String>();
    private String currentRefreshToken;
    private int currentRefreshTokenUseCount;
    private final UUID id;

    public AuthenticatedClientSessionEntity(UUID id) {
        this.id = id;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    public int getUserSessionStarted() {
        String started = this.getNotes().get("userSessionStartedAt");
        return started == null ? this.timestamp : Integer.parseInt(started);
    }

    public int getStarted() {
        String started = this.getNotes().get("startedAt");
        return started == null ? this.timestamp : Integer.parseInt(started);
    }

    public boolean isUserSessionRememberMe() {
        return Boolean.parseBoolean(this.getNotes().get("userSessionRememberMe"));
    }

    public String getClientId() {
        return this.getNotes().get(CLIENT_ID_NOTE);
    }

    public void setClientId(String clientId) {
        this.getNotes().put(CLIENT_ID_NOTE, clientId);
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Map<String, String> getNotes() {
        return this.notes;
    }

    public void setNotes(Map<String, String> notes) {
        this.notes = notes;
    }

    public String getCurrentRefreshToken() {
        return this.currentRefreshToken;
    }

    public void setCurrentRefreshToken(String currentRefreshToken) {
        this.currentRefreshToken = currentRefreshToken;
    }

    public int getCurrentRefreshTokenUseCount() {
        return this.currentRefreshTokenUseCount;
    }

    public void setCurrentRefreshTokenUseCount(int currentRefreshTokenUseCount) {
        this.currentRefreshTokenUseCount = currentRefreshTokenUseCount;
    }

    public UUID getId() {
        return this.id;
    }

    public String toString() {
        return "AuthenticatedClientSessionEntity [id=" + this.id + ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthenticatedClientSessionEntity)) {
            return false;
        }
        AuthenticatedClientSessionEntity that = (AuthenticatedClientSessionEntity)o;
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    @Override
    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    @Override
    public SessionEntityWrapper mergeRemoteEntityWithLocalEntity(SessionEntityWrapper localEntityWrapper) {
        SessionEntityWrapper<AuthenticatedClientSessionEntity> entityWrapper;
        int timestampRemote = this.getTimestamp();
        if (localEntityWrapper == null) {
            entityWrapper = new SessionEntityWrapper<AuthenticatedClientSessionEntity>(this);
        } else {
            AuthenticatedClientSessionEntity localClientSession = (AuthenticatedClientSessionEntity)localEntityWrapper.getEntity();
            if (timestampRemote < localClientSession.getTimestamp()) {
                this.setTimestamp(localClientSession.getTimestamp());
            }
            entityWrapper = new SessionEntityWrapper<AuthenticatedClientSessionEntity>(localEntityWrapper.getLocalMetadata(), this);
        }
        entityWrapper.putLocalMetadataNoteInt(LAST_TIMESTAMP_REMOTE, timestampRemote);
        logger.debugf("Updating client session entity %s. timestamp=%d, timestampRemote=%d", (Object)this.getId(), (Object)this.getTimestamp(), (Object)timestampRemote);
        return entityWrapper;
    }

    public static class ExternalizerImpl
    implements Externalizer<AuthenticatedClientSessionEntity> {
        public void writeObject(ObjectOutput output, AuthenticatedClientSessionEntity session) throws IOException {
            MarshallUtil.marshallUUID((UUID)session.id, (ObjectOutput)output, (boolean)false);
            MarshallUtil.marshallString((String)session.getRealmId(), (ObjectOutput)output);
            MarshallUtil.marshallString((String)session.getAuthMethod(), (ObjectOutput)output);
            MarshallUtil.marshallString((String)session.getRedirectUri(), (ObjectOutput)output);
            KeycloakMarshallUtil.marshall(session.getTimestamp(), output);
            MarshallUtil.marshallString((String)session.getAction(), (ObjectOutput)output);
            Map<String, String> notes = session.getNotes();
            KeycloakMarshallUtil.writeMap(notes, KeycloakMarshallUtil.STRING_EXT, KeycloakMarshallUtil.STRING_EXT, output);
            MarshallUtil.marshallString((String)session.getCurrentRefreshToken(), (ObjectOutput)output);
            KeycloakMarshallUtil.marshall(session.getCurrentRefreshTokenUseCount(), output);
        }

        public AuthenticatedClientSessionEntity readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            AuthenticatedClientSessionEntity sessionEntity = new AuthenticatedClientSessionEntity(MarshallUtil.unmarshallUUID((ObjectInput)input, (boolean)false));
            sessionEntity.setRealmId(MarshallUtil.unmarshallString((ObjectInput)input));
            sessionEntity.setAuthMethod(MarshallUtil.unmarshallString((ObjectInput)input));
            sessionEntity.setRedirectUri(MarshallUtil.unmarshallString((ObjectInput)input));
            sessionEntity.setTimestamp(KeycloakMarshallUtil.unmarshallInteger(input));
            sessionEntity.setAction(MarshallUtil.unmarshallString((ObjectInput)input));
            Object notes = KeycloakMarshallUtil.readMap(input, KeycloakMarshallUtil.STRING_EXT, KeycloakMarshallUtil.STRING_EXT, new KeycloakMarshallUtil.ConcurrentHashMapBuilder());
            sessionEntity.setNotes((Map<String, String>)notes);
            sessionEntity.setCurrentRefreshToken(MarshallUtil.unmarshallString((ObjectInput)input));
            sessionEntity.setCurrentRefreshTokenUseCount(KeycloakMarshallUtil.unmarshallInteger(input));
            return sessionEntity;
        }
    }
}

