/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.user.delegate;

import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.UUID;
import org.keycloak.models.map.common.EntityField;
import org.keycloak.models.map.common.delegate.DelegateProvider;
import org.keycloak.models.map.storage.jpa.JpaDelegateProvider;
import org.keycloak.models.map.storage.jpa.user.entity.JpaUserEntity;
import org.keycloak.models.map.user.MapUserEntity;
import org.keycloak.models.map.user.MapUserEntityFields;

public class JpaUserDelegateProvider
extends JpaDelegateProvider<JpaUserEntity>
implements DelegateProvider<MapUserEntity> {
    private final EntityManager em;

    public JpaUserDelegateProvider(JpaUserEntity delegate, EntityManager em) {
        super(delegate);
        this.em = em;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MapUserEntity getDelegate(boolean isRead, Enum<? extends EntityField<MapUserEntity>> field, Object ... parameters) {
        if (((JpaUserEntity)this.getDelegate()).isMetadataInitialized()) {
            return (MapUserEntity)this.getDelegate();
        }
        if (isRead) {
            if (!(field instanceof MapUserEntityFields)) throw new IllegalStateException("Not a valid realm field: " + field);
            switch ((MapUserEntityFields)field) {
                case ID: 
                case REALM_ID: 
                case USERNAME: 
                case FIRST_NAME: 
                case LAST_NAME: 
                case EMAIL: 
                case EMAIL_CONSTRAINT: 
                case FEDERATION_LINK: 
                case ENABLED: 
                case EMAIL_VERIFIED: 
                case CREATED_TIMESTAMP: {
                    return (MapUserEntity)this.getDelegate();
                }
                case ATTRIBUTES: {
                    this.setDelegateWithAssociation("attributes");
                    return (MapUserEntity)this.getDelegate();
                }
                case USER_CONSENTS: {
                    this.setDelegateWithAssociation("consents");
                    return (MapUserEntity)this.getDelegate();
                }
                case FEDERATED_IDENTITIES: {
                    this.setDelegateWithAssociation("federatedIdentities");
                    return (MapUserEntity)this.getDelegate();
                }
                default: {
                    this.setDelegate((JpaUserEntity)this.em.find(JpaUserEntity.class, (Object)UUID.fromString(((JpaUserEntity)this.getDelegate()).getId())));
                    return (MapUserEntity)this.getDelegate();
                }
            }
        } else {
            this.setDelegate((JpaUserEntity)this.em.find(JpaUserEntity.class, (Object)UUID.fromString(((JpaUserEntity)this.getDelegate()).getId())));
        }
        return (MapUserEntity)this.getDelegate();
    }

    protected void setDelegateWithAssociation(String associationName) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(JpaUserEntity.class);
        Root root = query.from(JpaUserEntity.class);
        root.fetch(associationName, JoinType.LEFT);
        query.select((Selection)root).where((Expression)cb.equal((Expression)root.get("id"), (Object)UUID.fromString(((JpaUserEntity)this.getDelegate()).getId())));
        this.setDelegate((JpaUserEntity)this.em.createQuery(query).getSingleResult());
    }
}

