/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.types;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.infinispan.protostream.annotations.ProtoDoc;

public final class DocumentationExtractor {
    public static final String PROTOSTREAM_ANNOTATIONS_PREFIX = "@org.infinispan.protostream.annotations";

    private static StringBuilder getDocumentation(ProtoDoc[] annotations) {
        int end;
        int start;
        for (start = 0; start < annotations.length && annotations[start].value().isEmpty(); ++start) {
        }
        for (end = annotations.length; end > start && annotations[end - 1].value().isEmpty(); --end) {
        }
        StringBuilder sb = null;
        for (int i = start; i < end; ++i) {
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append('\n');
            }
            sb.append(annotations[i].value());
        }
        return sb;
    }

    public static String getDocumentation(Element element, boolean fullyQualified) {
        StringBuilder docs = DocumentationExtractor.getDocumentation((ProtoDoc[])element.getAnnotationsByType(ProtoDoc.class));
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String s = annotationMirror.toString();
            docs = DocumentationExtractor.annotationToString(docs, s, fullyQualified);
        }
        return docs != null ? docs.toString() : null;
    }

    public static String getDocumentation(Field f, boolean fullyQualified) {
        StringBuilder docs = DocumentationExtractor.getDocumentation((ProtoDoc[])f.getAnnotationsByType(ProtoDoc.class));
        return DocumentationExtractor.getDocumentation(docs, f.getAnnotations(), fullyQualified);
    }

    public static String getDocumentation(Class<?> clazz, boolean fullyQualified) {
        StringBuilder docs = DocumentationExtractor.getDocumentation((ProtoDoc[])clazz.getAnnotationsByType(ProtoDoc.class));
        return DocumentationExtractor.getDocumentation(docs, clazz.getAnnotations(), fullyQualified);
    }

    public static String getDocumentation(Method method, boolean fullyQualified) {
        StringBuilder docs = DocumentationExtractor.getDocumentation((ProtoDoc[])method.getAnnotationsByType(ProtoDoc.class));
        return DocumentationExtractor.getDocumentation(docs, method.getAnnotations(), fullyQualified);
    }

    private static String getDocumentation(StringBuilder docs, Annotation[] annotations, boolean fullyQualified) {
        for (Annotation annotation : annotations) {
            String s = annotation.toString();
            docs = DocumentationExtractor.annotationToString(docs, s, fullyQualified);
        }
        return docs != null ? docs.toString() : null;
    }

    private static StringBuilder annotationToString(StringBuilder docs, String s, boolean fullyQualified) {
        if (!s.startsWith(PROTOSTREAM_ANNOTATIONS_PREFIX)) {
            if (docs == null) {
                docs = new StringBuilder();
            } else {
                docs.append('\n');
            }
            if (fullyQualified) {
                docs.append(s);
            } else {
                docs.append('@');
                int i = s.indexOf(40);
                i = i > 0 ? s.lastIndexOf(46, i) : s.lastIndexOf(46);
                docs.append(i > 0 ? s.substring(i + 1) : s.substring(1));
            }
        }
        return docs;
    }
}

