/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.client;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.map.client.MapClientProvider;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.provider.InvalidationHandler;
import org.keycloak.provider.ProviderEvent;

public class MapClientProviderFactory
extends AbstractMapProviderFactory<MapClientProvider, MapClientEntity, ClientModel>
implements ClientProviderFactory<MapClientProvider>,
InvalidationHandler {
    private final ConcurrentHashMap<String, ConcurrentMap<String, Long>> REGISTERED_NODES_STORE = new ConcurrentHashMap();

    public MapClientProviderFactory() {
        super(ClientModel.class, MapClientProvider.class);
    }

    @Override
    public MapClientProvider createNew(KeycloakSession session) {
        return new MapClientProvider(session, this.getMapStorage(session), this.REGISTERED_NODES_STORE);
    }

    public String getHelpText() {
        return "Client provider";
    }

    public void invalidate(final KeycloakSession session, InvalidationHandler.InvalidableObjectType type, final Object ... params) {
        if (type == AbstractMapProviderFactory.MapProviderObjectType.REALM_BEFORE_REMOVE) {
            ((MapClientProvider)this.create(session)).preRemove((RealmModel)params[0]);
        } else if (type == AbstractMapProviderFactory.MapProviderObjectType.ROLE_BEFORE_REMOVE) {
            ((MapClientProvider)this.create(session)).preRemove((RealmModel)params[0], (RoleModel)params[1]);
        } else if (type == AbstractMapProviderFactory.MapProviderObjectType.CLIENT_AFTER_REMOVE) {
            session.getKeycloakSessionFactory().publish((ProviderEvent)new ClientModel.ClientRemovedEvent(){

                public ClientModel getClient() {
                    return (ClientModel)params[0];
                }

                public KeycloakSession getKeycloakSession() {
                    return session;
                }
            });
        }
    }
}

