/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.mapping.AttributeContainer;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.sql.Alias;

public class Join
implements AttributeContainer,
Serializable {
    private static final Alias PK_ALIAS = new Alias(15, "PK");
    private final ArrayList<Property> properties = new ArrayList();
    private final ArrayList<Property> declaredProperties = new ArrayList();
    private Table table;
    private KeyValue key;
    private PersistentClass persistentClass;
    private boolean inverse;
    private boolean optional;
    private boolean disableForeignKeyCreation;
    private String customSQLInsert;
    private boolean customInsertCallable;
    private ExecuteUpdateResultCheckStyle insertCheckStyle;
    private String customSQLUpdate;
    private boolean customUpdateCallable;
    private ExecuteUpdateResultCheckStyle updateCheckStyle;
    private String customSQLDelete;
    private boolean customDeleteCallable;
    private ExecuteUpdateResultCheckStyle deleteCheckStyle;

    @Override
    public void addProperty(Property property) {
        this.properties.add(property);
        this.declaredProperties.add(property);
        property.setPersistentClass(this.persistentClass);
    }

    @Override
    public boolean contains(Property property) {
        return this.properties.contains(property);
    }

    public void addMappedSuperclassProperty(Property property) {
        this.properties.add(property);
        property.setPersistentClass(this.persistentClass);
    }

    public List<Property> getDeclaredProperties() {
        return this.declaredProperties;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    @Deprecated(since="6.0")
    public Iterator<Property> getDeclaredPropertyIterator() {
        return this.declaredProperties.iterator();
    }

    public boolean containsProperty(Property property) {
        return this.properties.contains(property);
    }

    @Deprecated(since="6.0")
    public Iterator<Property> getPropertyIterator() {
        return this.properties.iterator();
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public KeyValue getKey() {
        return this.key;
    }

    public void setKey(KeyValue key) {
        this.key = key;
    }

    public PersistentClass getPersistentClass() {
        return this.persistentClass;
    }

    public void setPersistentClass(PersistentClass persistentClass) {
        this.persistentClass = persistentClass;
    }

    public void disableForeignKeyCreation() {
        this.disableForeignKeyCreation = true;
    }

    public void createForeignKey() {
        ForeignKey foreignKey = this.getKey().createForeignKeyOfEntity(this.persistentClass.getEntityName());
        if (this.disableForeignKeyCreation) {
            foreignKey.disableCreation();
        }
    }

    public void createPrimaryKey() {
        PrimaryKey primaryKey = new PrimaryKey(this.table);
        primaryKey.setName(PK_ALIAS.toAliasString(this.table.getName()));
        this.table.setPrimaryKey(primaryKey);
        primaryKey.addColumns(this.getKey());
    }

    public int getPropertySpan() {
        return this.properties.size();
    }

    public void setCustomSQLInsert(String customSQLInsert, boolean callable, ExecuteUpdateResultCheckStyle checkStyle) {
        this.customSQLInsert = customSQLInsert;
        this.customInsertCallable = callable;
        this.insertCheckStyle = checkStyle;
    }

    public String getCustomSQLInsert() {
        return this.customSQLInsert;
    }

    public boolean isCustomInsertCallable() {
        return this.customInsertCallable;
    }

    public ExecuteUpdateResultCheckStyle getCustomSQLInsertCheckStyle() {
        return this.insertCheckStyle;
    }

    public void setCustomSQLUpdate(String customSQLUpdate, boolean callable, ExecuteUpdateResultCheckStyle checkStyle) {
        this.customSQLUpdate = customSQLUpdate;
        this.customUpdateCallable = callable;
        this.updateCheckStyle = checkStyle;
    }

    public String getCustomSQLUpdate() {
        return this.customSQLUpdate;
    }

    public boolean isCustomUpdateCallable() {
        return this.customUpdateCallable;
    }

    public ExecuteUpdateResultCheckStyle getCustomSQLUpdateCheckStyle() {
        return this.updateCheckStyle;
    }

    public void setCustomSQLDelete(String customSQLDelete, boolean callable, ExecuteUpdateResultCheckStyle checkStyle) {
        this.customSQLDelete = customSQLDelete;
        this.customDeleteCallable = callable;
        this.deleteCheckStyle = checkStyle;
    }

    public String getCustomSQLDelete() {
        return this.customSQLDelete;
    }

    public boolean isCustomDeleteCallable() {
        return this.customDeleteCallable;
    }

    public ExecuteUpdateResultCheckStyle getCustomSQLDeleteCheckStyle() {
        return this.deleteCheckStyle;
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public void setInverse(boolean leftJoin) {
        this.inverse = leftJoin;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.table.getName() + ")";
    }

    public boolean isLazy() {
        for (Property property : this.properties) {
            if (property.isLazy()) continue;
            return false;
        }
        return true;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean nullable) {
        this.optional = nullable;
    }
}

