/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AccessorPrototype;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.ClobAccessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.sql.CLOB;

class T4CClobAccessor
extends ClobAccessor {
    T4CMAREngine mare;
    short[] prefetchedClobCharset = null;
    boolean[] prefetchedClobDBVary = null;
    final int[] meta = new int[1];
    ArrayList<LinkedList<CLOB>> registeredCLOBs = new ArrayList(10);

    T4CClobAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, 4000, form, external_type, isOutBind, false);
        this.mare = _mare;
    }

    T4CClobAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare) throws SQLException {
        super(stmt, 4000, nullable, flags, precision, scale, contflag, total_elems, form);
        this.mare = _mare;
        this.definedColumnType = _definedColumnType;
        this.definedColumnSize = _definedColumnSize;
    }

    public T4CMAREngine getMAREngine() {
        return this.mare;
    }

    public void unmarshalColumnMetadata() throws SQLException, IOException {
        if (this.statement.statementType != 2 && !this.statement.sqlKind.isPlsqlOrCall() && this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
            this.setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
        }
    }

    public void processIndicator(int size) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalSB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(size <= 0, size);
        }
    }

    @Override
    int getPreviousRowProcessed() {
        if (this.previousRowProcessed == -1) {
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        }
        return this.previousRowProcessed;
    }

    @Override
    void reinitForResultSetCache(ByteArray dba, OracleStatement stmt) throws SQLException {
        this.rowData = dba;
        this.mare = ((T4CConnection)stmt.connection).mare;
        this.rowNull = null;
        this.setCapacity(stmt.getFetchSize());
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        boolean isStream = false;
        if (!this.isUseless()) {
            if (this.isUnexpected()) {
                long pos = this.rowData.getPosition();
                this.unmarshalColumnMetadata();
                this.unmarshalBytes();
                this.rowData.setPosition(pos);
                this.setNull(this.lastRowProcessed, true);
            } else if (this.isNullByDescribe()) {
                this.setNull(this.lastRowProcessed, true);
                this.unmarshalColumnMetadata();
                if (this.statement.connection.versionNumber < 9200) {
                    this.processIndicator(0);
                }
            } else {
                this.unmarshalColumnMetadata();
                isStream = this.unmarshalBytes();
            }
        }
        this.previousRowProcessed = this.lastRowProcessed++;
        return isStream;
    }

    @Override
    void copyRow() throws SQLException, IOException {
        throw new NoSuchMethodError("oracle.jdbc.driver.T4C_lobAccessor.copyRow");
    }

    boolean unmarshalBytes() throws IOException, SQLException {
        int len = (int)this.mare.unmarshalUB4();
        if (len == 0) {
            this.setNull(this.lastRowProcessed, true);
            this.processIndicator(0);
        } else {
            if (this.isPrefetched()) {
                this.unmarshalPrefetchData();
            }
            this.setOffset(this.lastRowProcessed);
            int actualLength = ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare);
            this.setNull(this.lastRowProcessed, actualLength == 0);
            this.setLength(this.lastRowProcessed, actualLength);
            this.processIndicator(actualLength);
        }
        return false;
    }

    void unmarshalPrefetchData() throws SQLException, IOException {
        this.setPrefetchedLength(this.lastRowProcessed, this.mare.unmarshalSB8());
        this.setPrefetchedChunkSize(this.lastRowProcessed, (int)this.mare.unmarshalUB4());
        if (this.lobPrefetchSizeForThisColumn > 0) {
            boolean dbVary;
            boolean bl = dbVary = (byte)this.mare.unmarshalUB1() == 1;
            if (dbVary) {
                this.setPrefetchedDataCharset(this.lastRowProcessed, this.mare.unmarshalUB2());
            } else {
                this.setPrefetchedDataCharset(this.lastRowProcessed, 0);
            }
            this.setPrefetchedDataFormOfUse(this.lastRowProcessed, this.mare.unmarshalUB1());
            this.setPrefetchedDataOffset(this.lastRowProcessed);
            this.setPrefetchedDataLength(this.lastRowProcessed, ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare));
        } else {
            this.setPrefetchedDataOffset(this.lastRowProcessed);
            this.setPrefetchedDataLength(this.lastRowProcessed, 0);
        }
    }

    private void saveCLOBReference(int rowPosition, CLOB clob) {
        LinkedList<Object> clobsAtThisRow = null;
        if (this.registeredCLOBs.size() > rowPosition) {
            clobsAtThisRow = this.registeredCLOBs.get(rowPosition);
        } else {
            clobsAtThisRow = new LinkedList();
            while (this.registeredCLOBs.size() < rowPosition) {
                this.registeredCLOBs.add(new LinkedList());
            }
            this.registeredCLOBs.add(rowPosition, clobsAtThisRow);
        }
        if (clobsAtThisRow == null) {
            clobsAtThisRow = new LinkedList();
        }
        clobsAtThisRow.add(clob);
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(currentRow);
        }
        if (this.isNull(currentRow)) {
            return null;
        }
        switch (this.definedColumnType) {
            case 2011: {
                return this.getNCLOB(currentRow);
            }
            case 2005: {
                return this.getCLOB(currentRow);
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(currentRow);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(currentRow);
            }
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
    }

    @Override
    AccessorPrototype newPrototype(int numRows) {
        assert (numRows >= 0) : "numRows: " + numRows;
        AccessorPrototype p = new AccessorPrototype(numRows, this, this.statement.rowData){

            @Override
            Accessor newAccessor(OracleStatement stmt) throws SQLException {
                T4CClobAccessor acc = new T4CClobAccessor(stmt, T4CClobAccessor.this.describeMaxLength, T4CClobAccessor.this.nullable, -1, T4CClobAccessor.this.precision, T4CClobAccessor.this.scale, T4CClobAccessor.this.contflag, -1, T4CClobAccessor.this.formOfUse, T4CClobAccessor.this.definedColumnType, T4CClobAccessor.this.definedColumnSize, null);
                this.initializeRowData(acc);
                return acc;
            }
        };
        return p;
    }
}

