/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.conflict.impl;

import jakarta.transaction.TransactionManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.cache.impl.InvocationHelper;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.SegmentSpecificCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.remote.BaseClusteredReadCommand;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.PartitionHandlingConfiguration;
import org.infinispan.conflict.EntryMergePolicy;
import org.infinispan.conflict.EntryMergePolicyFactoryRegistry;
import org.infinispan.conflict.impl.InternalConflictManager;
import org.infinispan.conflict.impl.StateReceiver;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.NullCacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.UnsureResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class DefaultConflictManager<K, V>
implements InternalConflictManager<K, V> {
    private static Log log = LogFactory.getLog(DefaultConflictManager.class);
    private static final long localFlags = FlagBitSets.CACHE_MODE_LOCAL | FlagBitSets.SKIP_OWNERSHIP_CHECK | FlagBitSets.SKIP_LOCKING;
    private static final long userMergeFlags = FlagBitSets.IGNORE_RETURN_VALUES;
    private static final long autoMergeFlags = FlagBitSets.IGNORE_RETURN_VALUES | FlagBitSets.PUT_FOR_STATE_TRANSFER | FlagBitSets.SKIP_REMOTE_LOOKUP;
    @ComponentName(value="cacheName")
    @Inject
    String cacheName;
    @Inject
    ComponentRef<AsyncInterceptorChain> interceptorChain;
    @Inject
    InvocationHelper invocationHelper;
    @Inject
    Configuration cacheConfiguration;
    @Inject
    CommandsFactory commandsFactory;
    @Inject
    DistributionManager distributionManager;
    @Inject
    InvocationContextFactory invocationContextFactory;
    @Inject
    RpcManager rpcManager;
    @Inject
    ComponentRef<StateConsumer> stateConsumer;
    @Inject
    StateReceiver<K, V> stateReceiver;
    @Inject
    EntryMergePolicyFactoryRegistry mergePolicyRegistry;
    @Inject
    TimeService timeService;
    @Inject
    BlockingManager blockingManager;
    @Inject
    InternalEntryFactory internalEntryFactory;
    @Inject
    TransactionManager transactionManager;
    @Inject
    KeyPartitioner keyPartitioner;
    private Address localAddress;
    private long conflictTimeout;
    private EntryMergePolicy<K, V> entryMergePolicy;
    private BlockingManager.BlockingExecutor resolutionExecutor;
    private final AtomicBoolean streamInProgress = new AtomicBoolean();
    private final Map<K, VersionRequest> versionRequestMap = new HashMap<K, VersionRequest>();
    private final Queue<VersionRequest> retryQueue = new ConcurrentLinkedQueue<VersionRequest>();
    private volatile boolean running = false;
    private volatile ReplicaSpliterator conflictSpliterator;
    private volatile CompletableFuture<Void> conflictFuture;

    @Start
    public void start() {
        this.localAddress = this.rpcManager.getAddress();
        PartitionHandlingConfiguration config = this.cacheConfiguration.clustering().partitionHandling();
        this.entryMergePolicy = this.mergePolicyRegistry.createInstance(config);
        this.conflictTimeout = this.cacheConfiguration.clustering().stateTransfer().timeout();
        this.resolutionExecutor = this.blockingManager.limitedBlockingExecutor("ConflictManager-" + this.cacheName, 1);
        this.running = true;
        if (log.isTraceEnabled()) {
            log.tracef("Cache %s starting %s. isRunning=%s", this.cacheName, this.getClass().getSimpleName(), !this.running);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Stop(priority=0)
    public void stop() {
        this.running = false;
        Map<K, VersionRequest> map = this.versionRequestMap;
        synchronized (map) {
            if (log.isTraceEnabled()) {
                log.tracef("Cache %s stopping %s. isRunning=%s", this.getClass().getSimpleName(), this.cacheName, this.running);
            }
            this.cancelVersionRequests();
            this.versionRequestMap.clear();
        }
        if (this.isConflictResolutionInProgress() && this.conflictSpliterator != null) {
            this.conflictSpliterator.stop();
        }
    }

    @Override
    public StateReceiver getStateReceiver() {
        return this.stateReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelVersionRequests() {
        if (!this.running) {
            return;
        }
        Map<K, VersionRequest> map = this.versionRequestMap;
        synchronized (map) {
            this.versionRequestMap.values().forEach(VersionRequest::cancelRequestIfOutdated);
        }
    }

    @Override
    public void restartVersionRequests() {
        VersionRequest request;
        if (!this.running) {
            return;
        }
        while ((request = this.retryQueue.poll()) != null) {
            if (log.isTraceEnabled()) {
                log.tracef("Retrying %s", request);
            }
            request.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Address, InternalCacheValue<V>> getAllVersions(K key) {
        VersionRequest request;
        this.checkIsRunning();
        Map<Object, Object> map = this.versionRequestMap;
        synchronized (map) {
            request = this.versionRequestMap.computeIfAbsent(key, k -> new VersionRequest(k, this.stateConsumer.running().isStateTransferInProgress()));
        }
        try {
            map = request.completableFuture.get();
            return map;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CacheException) {
                throw (CacheException)e.getCause();
            }
            throw new CacheException(e.getCause());
        }
        finally {
            Map<K, VersionRequest> map2 = this.versionRequestMap;
            synchronized (map2) {
                this.versionRequestMap.remove(key);
            }
        }
    }

    @Override
    public Stream<Map<Address, CacheEntry<K, V>>> getConflicts() {
        this.checkIsRunning();
        return this.getConflicts(this.distributionManager.getCacheTopology());
    }

    private Stream<Map<Address, CacheEntry<K, V>>> getConflicts(LocalizedCacheTopology topology) {
        if (log.isTraceEnabled()) {
            log.tracef("getConflicts isStateTransferInProgress=%s, topology=%s", this.stateConsumer.running().isStateTransferInProgress(), topology);
        }
        if (topology.getPhase() != CacheTopology.Phase.CONFLICT_RESOLUTION && this.stateConsumer.running().isStateTransferInProgress()) {
            throw Log.CLUSTER.getConflictsStateTransferInProgress(this.cacheName);
        }
        if (!this.streamInProgress.compareAndSet(false, true)) {
            throw Log.CLUSTER.getConflictsAlreadyInProgress();
        }
        this.conflictSpliterator = new ReplicaSpliterator(topology);
        if (!this.running) {
            this.conflictSpliterator.stop();
            return Stream.empty();
        }
        return StreamSupport.stream(new ReplicaSpliterator(topology), false).filter(this.filterConsistentEntries());
    }

    @Override
    public boolean isConflictResolutionInProgress() {
        return this.streamInProgress.get();
    }

    @Override
    public void resolveConflicts() {
        if (this.entryMergePolicy == null) {
            throw new CacheException("Cannot resolve conflicts as no EntryMergePolicy has been configured");
        }
        this.resolveConflicts(this.entryMergePolicy);
    }

    @Override
    public void resolveConflicts(EntryMergePolicy<K, V> mergePolicy) {
        this.checkIsRunning();
        this.doResolveConflicts(this.distributionManager.getCacheTopology(), mergePolicy, null);
    }

    @Override
    public CompletionStage<Void> resolveConflicts(CacheTopology topology, Set<Address> preferredNodes) {
        if (!this.running) {
            return CompletableFuture.completedFuture(null);
        }
        LocalizedCacheTopology localizedTopology = topology instanceof LocalizedCacheTopology ? (LocalizedCacheTopology)topology : this.distributionManager.createLocalizedCacheTopology(topology);
        this.conflictFuture = this.resolutionExecutor.execute(() -> this.doResolveConflicts(localizedTopology, this.entryMergePolicy, preferredNodes), localizedTopology.getTopologyId()).toCompletableFuture();
        return this.conflictFuture.whenComplete((Void2, t) -> {
            if (t != null && this.conflictSpliterator != null) {
                this.conflictSpliterator.stop();
                this.conflictSpliterator = null;
            }
        });
    }

    @Override
    public void cancelConflictResolution() {
        if (this.conflictFuture != null && !this.conflictFuture.isDone()) {
            if (log.isTraceEnabled()) {
                log.tracef("Cache %s cancelling conflict resolution future", this.cacheName);
            }
            this.conflictFuture.cancel(true);
        }
    }

    private void doResolveConflicts(LocalizedCacheTopology topology, EntryMergePolicy<K, V> mergePolicy, Set<Address> preferredNodes) {
        HashSet<Address> preferredPartition;
        boolean userCall = preferredNodes == null;
        HashSet<Address> hashSet = preferredPartition = userCall ? new HashSet<Address>(topology.getCurrentCH().getMembers()) : preferredNodes;
        if (log.isTraceEnabled()) {
            log.tracef("Cache %s attempting to resolve conflicts.  All Members %s, Installed topology %s, Preferred Partition %s", new Object[]{this.cacheName, topology.getMembers(), topology, preferredPartition});
        }
        Phaser phaser = new Phaser(1);
        this.getConflicts(topology).forEach(conflictMap -> {
            phaser.register();
            if (log.isTraceEnabled()) {
                log.tracef("Cache %s conflict detected %s", this.cacheName, conflictMap);
            }
            Collection entries = conflictMap.values();
            Optional<Object> optionalEntry = entries.stream().filter(entry -> !(entry instanceof NullCacheEntry)).map(CacheEntry::getKey).findAny();
            Object key = optionalEntry.orElseThrow(() -> new CacheException("All returned conflicts are NullCacheEntries. This should not happen!"));
            Address primaryReplica = topology.getDistribution(key).primary();
            List preferredEntries = conflictMap.entrySet().stream().map(Map.Entry::getKey).filter(preferredPartition::contains).collect(Collectors.toList());
            CacheEntry preferredEntry = preferredEntries.size() == 1 ? (CacheEntry)conflictMap.remove(preferredEntries.get(0)) : (CacheEntry)conflictMap.remove(primaryReplica);
            if (log.isTraceEnabled()) {
                log.tracef("Cache %s applying EntryMergePolicy %s to PreferredEntry %s, otherEntries %s", new Object[]{this.cacheName, mergePolicy.getClass().getName(), preferredEntry, entries});
            }
            CacheEntry entry2 = preferredEntry instanceof NullCacheEntry ? null : preferredEntry;
            List otherEntries = entries.stream().filter(e -> !(e instanceof NullCacheEntry)).collect(Collectors.toList());
            CacheEntry mergedEntry = mergePolicy.merge(entry2, otherEntries);
            CompletableFuture future = this.applyMergeResult(userCall, key, mergedEntry);
            future.whenComplete((responseMap, exception) -> {
                if (log.isTraceEnabled()) {
                    log.tracef("Cache %s resolveConflicts future complete for key %s: ResponseMap=%s", this.cacheName, key, responseMap);
                }
                phaser.arriveAndDeregister();
                if (exception != null) {
                    log.exceptionDuringConflictResolution(key, (Throwable)exception);
                }
            });
        });
        phaser.arriveAndAwaitAdvance();
        if (log.isTraceEnabled()) {
            log.tracef("Cache %s finished resolving conflicts for topologyId=%s", this.cacheName, topology.getTopologyId());
        }
    }

    private CompletableFuture<V> applyMergeResult(boolean userCall, K key, CacheEntry<K, V> mergedEntry) {
        AbstractDataWriteCommand command;
        long flags;
        long l = flags = userCall ? userMergeFlags : autoMergeFlags;
        if (mergedEntry == null) {
            if (log.isTraceEnabled()) {
                log.tracef("Cache %s executing remove on conflict: key %s", this.cacheName, key);
            }
            command = this.commandsFactory.buildRemoveCommand(key, null, this.keyPartitioner.getSegment(key), flags);
        } else {
            if (log.isTraceEnabled()) {
                log.tracef("Cache %s executing update on conflict: key %s with value %s", this.cacheName, key, mergedEntry.getValue());
            }
            command = this.commandsFactory.buildPutKeyValueCommand(key, mergedEntry.getValue(), this.keyPartitioner.getSegment(key), mergedEntry.getMetadata(), flags);
        }
        try {
            assert (this.transactionManager == null || this.transactionManager.getTransaction() == null) : "Transaction active on conflict resolution thread";
            InvocationContext ctx = this.invocationHelper.createInvocationContextWithImplicitTransaction(1, true);
            return this.invocationHelper.invokeAsync(ctx, command);
        }
        catch (Exception e) {
            return CompletableFutures.completedExceptionFuture((Throwable)e);
        }
    }

    @Override
    public boolean isStateTransferInProgress() {
        return this.stateConsumer.running().isStateTransferInProgress();
    }

    private void checkIsRunning() {
        if (!this.running) {
            throw new CacheException(String.format("Cache %s unable to process request as the ConflictManager has been stopped", this.cacheName));
        }
    }

    private Predicate<? super Map<Address, CacheEntry<K, V>>> filterConsistentEntries() {
        return map -> map.values().stream().distinct().limit(2L).count() > 1L || map.values().isEmpty();
    }

    private class ReplicaSpliterator
    extends Spliterators.AbstractSpliterator<Map<Address, CacheEntry<K, V>>> {
        private final LocalizedCacheTopology topology;
        private final int totalSegments;
        private final long endTime;
        private int nextSegment;
        private Iterator<Map<Address, CacheEntry<K, V>>> iterator;
        private volatile CompletableFuture<List<Map<Address, CacheEntry<K, V>>>> segmentRequestFuture;

        ReplicaSpliterator(LocalizedCacheTopology topology) {
            super(Long.MAX_VALUE, 257);
            this.nextSegment = 0;
            this.iterator = Collections.emptyIterator();
            this.topology = topology;
            this.totalSegments = topology.getWriteConsistentHash().getNumSegments();
            this.endTime = DefaultConflictManager.this.timeService.expectedEndTime(DefaultConflictManager.this.conflictTimeout, TimeUnit.MILLISECONDS);
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map<Address, CacheEntry<K, V>>> action) {
            while (!this.iterator.hasNext()) {
                if (this.nextSegment < this.totalSegments) {
                    try {
                        if (log.isTraceEnabled()) {
                            log.tracef("Cache %s attempting to receive all replicas for segment %s with topology %s", DefaultConflictManager.this.cacheName, this.nextSegment, this.topology);
                        }
                        long remainingTime = DefaultConflictManager.this.timeService.remainingTime(this.endTime, TimeUnit.MILLISECONDS);
                        this.segmentRequestFuture = DefaultConflictManager.this.stateReceiver.getAllReplicasForSegment(this.nextSegment, this.topology, remainingTime);
                        List segmentEntries = this.segmentRequestFuture.get(remainingTime, TimeUnit.MILLISECONDS);
                        if (log.isTraceEnabled()) {
                            log.tracef("Cache %s segment %s entries received: %s", DefaultConflictManager.this.cacheName, this.nextSegment, segmentEntries);
                        }
                        ++this.nextSegment;
                        this.iterator = segmentEntries.iterator();
                        continue;
                    }
                    catch (Exception e) {
                        if (log.isTraceEnabled()) {
                            log.tracef("Cache %s replicaSpliterator caught %s", DefaultConflictManager.this.cacheName, e);
                        }
                        this.stopStream();
                        return this.handleException(e);
                    }
                }
                DefaultConflictManager.this.streamInProgress.compareAndSet(true, false);
                return false;
            }
            action.accept(this.iterator.next());
            return true;
        }

        void stop() {
            if (log.isTraceEnabled()) {
                log.tracef("Cache %s stop() called on ReplicaSpliterator. Current segment %s", DefaultConflictManager.this.cacheName, this.nextSegment);
            }
            if (this.segmentRequestFuture != null && !this.segmentRequestFuture.isDone()) {
                this.segmentRequestFuture.cancel(true);
            }
            DefaultConflictManager.this.streamInProgress.set(false);
        }

        void stopStream() {
            DefaultConflictManager.this.stateReceiver.cancelRequests();
            DefaultConflictManager.this.streamInProgress.set(false);
        }

        private boolean handleException(Throwable t) {
            Throwable cause = t.getCause();
            if (t instanceof CancellationException || cause instanceof CancellationException) {
                return false;
            }
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                throw new CacheException(t);
            }
            throw new CacheException(t.getMessage(), cause != null ? cause : t);
        }
    }

    private class VersionRequest {
        final K key;
        final boolean postpone;
        final CompletableFuture<Map<Address, InternalCacheValue<V>>> completableFuture = new CompletableFuture();
        volatile CompletableFuture<Map<Address, Response>> rpcFuture;
        volatile Collection<Address> keyOwners;

        VersionRequest(K key, boolean postpone) {
            this.key = key;
            this.postpone = postpone;
            if (log.isTraceEnabled()) {
                log.tracef("Cache %s creating %s", DefaultConflictManager.this.cacheName, this);
            }
            if (postpone) {
                DefaultConflictManager.this.retryQueue.add(this);
            } else {
                this.start();
            }
        }

        void cancelRequestIfOutdated() {
            Collection<Address> latestOwners = DefaultConflictManager.this.distributionManager.getCacheTopology().getWriteOwners(this.key);
            if (this.rpcFuture != null && !this.completableFuture.isDone() && !this.keyOwners.equals(latestOwners)) {
                this.rpcFuture = null;
                this.keyOwners.clear();
                if (this.rpcFuture.cancel(false)) {
                    DefaultConflictManager.this.retryQueue.add(this);
                    if (log.isTraceEnabled()) {
                        log.tracef("Cancelling %s for nodes %s. New write owners %s", this, this.keyOwners, latestOwners);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void start() {
            SegmentSpecificCommand cmd;
            LocalizedCacheTopology topology = DefaultConflictManager.this.distributionManager.getCacheTopology();
            DistributionInfo info = topology.getDistribution(this.key);
            this.keyOwners = info.writeOwners();
            if (log.isTraceEnabled()) {
                log.tracef("Attempting %s from owners %s", this, this.keyOwners);
            }
            HashMap versionsMap = new HashMap();
            if (this.keyOwners.contains(DefaultConflictManager.this.localAddress)) {
                cmd = DefaultConflictManager.this.commandsFactory.buildGetCacheEntryCommand(this.key, info.segmentId(), localFlags);
                NonTxInvocationContext ctx = DefaultConflictManager.this.invocationContextFactory.createNonTxInvocationContext();
                CacheEntry entry = (CacheEntry)DefaultConflictManager.this.interceptorChain.running().invoke(ctx, (VisitableCommand)((Object)cmd));
                InternalCacheValue icv = entry != null ? DefaultConflictManager.this.internalEntryFactory.createValue(entry) : null;
                HashMap hashMap = versionsMap;
                synchronized (hashMap) {
                    versionsMap.put(DefaultConflictManager.this.localAddress, icv);
                }
            }
            cmd = DefaultConflictManager.this.commandsFactory.buildClusteredGetCommand(this.key, info.segmentId(), FlagBitSets.SKIP_OWNERSHIP_CHECK);
            ((BaseClusteredReadCommand)((Object)cmd)).setTopologyId(topology.getTopologyId());
            MapResponseCollector collector = MapResponseCollector.ignoreLeavers(this.keyOwners.size());
            this.rpcFuture = DefaultConflictManager.this.rpcManager.invokeCommand(this.keyOwners, (ReplicableCommand)((Object)cmd), collector, DefaultConflictManager.this.rpcManager.getSyncRpcOptions()).toCompletableFuture();
            this.rpcFuture.whenComplete((responseMap, exception) -> {
                if (log.isTraceEnabled()) {
                    log.tracef("%s received responseMap %s, exception %s", this, responseMap, exception);
                }
                if (exception != null) {
                    String msg = String.format("%s encountered when attempting '%s' on cache '%s'", exception.getCause(), this, DefaultConflictManager.this.cacheName);
                    this.completableFuture.completeExceptionally((Throwable)new CacheException(msg, exception.getCause()));
                    return;
                }
                for (Map.Entry entry : responseMap.entrySet()) {
                    Response rsp;
                    if (log.isTraceEnabled()) {
                        log.tracef("%s received response %s from %s", this, entry.getValue(), entry.getKey());
                    }
                    if ((rsp = (Response)entry.getValue()) instanceof SuccessfulResponse) {
                        SuccessfulResponse response = (SuccessfulResponse)rsp;
                        Object rspVal = response.getResponseValue();
                        Map map = versionsMap;
                        synchronized (map) {
                            versionsMap.put((Address)entry.getKey(), (InternalCacheValue)rspVal);
                            continue;
                        }
                    }
                    if (rsp instanceof UnsureResponse) {
                        log.debugf("Received UnsureResponse, restarting request %s", this);
                        this.start();
                        return;
                    }
                    if (rsp instanceof CacheNotFoundResponse) {
                        if (!log.isTraceEnabled()) continue;
                        log.tracef("Ignoring CacheNotFoundResponse: %s", rsp);
                        continue;
                    }
                    this.completableFuture.completeExceptionally((Throwable)new CacheException(String.format("Unable to retrieve key %s from %s: %s", this.key, entry.getKey(), entry.getValue())));
                    return;
                }
                this.completableFuture.complete(versionsMap);
            });
        }

        public String toString() {
            return "VersionRequest{key=" + this.key + ", postpone=" + this.postpone + "}";
        }
    }
}

