/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.logging;

import java.nio.charset.Charset;
import java.util.function.Supplier;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.formatters.ColorPatternFormatter;
import org.jboss.logmanager.formatters.FormatStep;
import org.jboss.logmanager.formatters.PatternFormatter;
import org.wildfly.common.annotation.NotNull;

public class BannerFormatter
extends ColorPatternFormatter {
    private final Supplier<String> bannerSupplier;
    private Formatter formatter;
    private boolean isColorPattern;

    BannerFormatter(@NotNull Formatter formatter, boolean isColorPattern, Supplier<String> bannerSupplier) {
        this.formatter = formatter;
        this.isColorPattern = isColorPattern;
        this.bannerSupplier = bannerSupplier;
        if (isColorPattern) {
            this.setPattern(((ColorPatternFormatter)formatter).getPattern());
        } else {
            this.setPattern(((PatternFormatter)formatter).getPattern());
        }
    }

    public String formatMessage(LogRecord logRecord) {
        if (this.isColorPattern) {
            return super.formatMessage(logRecord);
        }
        return this.formatter.format(logRecord);
    }

    public void setSteps(FormatStep[] steps) {
        if (this.isColorPattern) {
            super.setSteps(steps);
        } else {
            ((PatternFormatter)this.formatter).setSteps(steps);
        }
    }

    public String format(ExtLogRecord extLogRecord) {
        if (this.isColorPattern) {
            return ((ColorPatternFormatter)this.formatter).format(extLogRecord);
        }
        return ((PatternFormatter)this.formatter).format(extLogRecord);
    }

    public String getHead(Handler h) {
        String banner = this.bannerSupplier.get();
        String encoding = h.getEncoding();
        try {
            Charset charset = encoding == null ? Charset.defaultCharset() : Charset.forName(encoding);
            return charset.newEncoder().canEncode(banner) ? banner : "";
        }
        catch (IllegalArgumentException ignored) {
            return "";
        }
    }
}

