/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer.cbor;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.webauthn4j.util.CertificateUtil;
import java.io.IOException;
import java.security.cert.X509Certificate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class X509CertificateDeserializer
extends StdDeserializer<X509Certificate> {
    public X509CertificateDeserializer() {
        super(X509Certificate.class);
    }

    public @Nullable X509Certificate deserialize(@NonNull JsonParser p, @NonNull DeserializationContext ctxt) throws IOException {
        byte[] value = p.getBinaryValue();
        if (value.length == 0) {
            return null;
        }
        return CertificateUtil.generateX509Certificate((byte[])value);
    }
}

