/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.realm;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UndefinedValuesUtils;
import org.keycloak.models.map.realm.MapRealmEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticationExecutionEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticationFlowEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticatorConfigEntity;
import org.keycloak.models.map.realm.entity.MapClientInitialAccessEntity;
import org.keycloak.models.map.realm.entity.MapComponentEntity;
import org.keycloak.models.map.realm.entity.MapIdentityProviderEntity;
import org.keycloak.models.map.realm.entity.MapIdentityProviderMapperEntity;
import org.keycloak.models.map.realm.entity.MapOTPPolicyEntity;
import org.keycloak.models.map.realm.entity.MapRequiredActionProviderEntity;
import org.keycloak.models.map.realm.entity.MapRequiredCredentialEntity;
import org.keycloak.models.map.realm.entity.MapWebAuthnPolicyEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodAttributeEntityNonIndexed;
import org.keycloak.models.map.storage.hotRod.common.HotRodEntityDelegate;
import org.keycloak.models.map.storage.hotRod.common.HotRodPair;
import org.keycloak.models.map.storage.hotRod.common.HotRodTypesUtils;
import org.keycloak.models.map.storage.hotRod.realm.HotRodRealmEntity;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodAuthenticationExecutionEntity;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodAuthenticationExecutionEntityDelegate;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodAuthenticationFlowEntity;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodAuthenticationFlowEntityDelegate;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodAuthenticatorConfigEntity;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodAuthenticatorConfigEntityDelegate;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodClientInitialAccessEntity;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodClientInitialAccessEntityDelegate;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodComponentEntity;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodComponentEntityDelegate;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodIdentityProviderEntity;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodIdentityProviderEntityDelegate;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodIdentityProviderMapperEntity;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodIdentityProviderMapperEntityDelegate;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodLocalizationTexts;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodOTPPolicyEntity;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodOTPPolicyEntityDelegate;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodRequiredActionProviderEntity;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodRequiredActionProviderEntityDelegate;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodRequiredCredentialEntity;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodRequiredCredentialEntityDelegate;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodWebAuthnPolicyEntity;
import org.keycloak.models.map.storage.hotRod.realm.entity.HotRodWebAuthnPolicyEntityDelegate;

public class HotRodRealmEntityDelegate
extends HotRodRealmEntity.AbstractHotRodRealmEntityDelegate
implements MapRealmEntity {
    private final HotRodRealmEntity hotRodEntity;
    private final DeepCloner cloner;

    public HotRodRealmEntityDelegate() {
        this.cloner = DeepCloner.DUMB_CLONER;
        this.hotRodEntity = new HotRodRealmEntity();
    }

    public HotRodRealmEntityDelegate(HotRodRealmEntity hotRodEntity) {
        Objects.requireNonNull(hotRodEntity);
        this.hotRodEntity = hotRodEntity;
        this.cloner = DeepCloner.DUMB_CLONER;
    }

    public HotRodRealmEntityDelegate(DeepCloner cloner) {
        this.hotRodEntity = new HotRodRealmEntity();
        this.cloner = cloner;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HotRodRealmEntityDelegate)) {
            return false;
        }
        HotRodRealmEntityDelegate other = (HotRodRealmEntityDelegate)o;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getAccessCodeLifespan(), other.getAccessCodeLifespan()) && Objects.equals(this.getAccessCodeLifespanLogin(), other.getAccessCodeLifespanLogin()) && Objects.equals(this.getAccessCodeLifespanUserAction(), other.getAccessCodeLifespanUserAction()) && Objects.equals(this.getAccessTokenLifespan(), other.getAccessTokenLifespan()) && Objects.equals(this.getAccessTokenLifespanForImplicitFlow(), other.getAccessTokenLifespanForImplicitFlow()) && Objects.equals(this.getAccountTheme(), other.getAccountTheme()) && Objects.equals(this.getActionTokenGeneratedByAdminLifespan(), other.getActionTokenGeneratedByAdminLifespan()) && Objects.equals(this.getAdminTheme(), other.getAdminTheme()) && Objects.equals(this.getAttributes(), other.getAttributes()) && Objects.equals(this.getAuthenticationExecutions(), other.getAuthenticationExecutions()) && Objects.equals(this.getAuthenticationFlows(), other.getAuthenticationFlows()) && Objects.equals(this.getAuthenticatorConfigs(), other.getAuthenticatorConfigs()) && Objects.equals(this.getBrowserFlow(), other.getBrowserFlow()) && Objects.equals(this.getBrowserSecurityHeaders(), other.getBrowserSecurityHeaders()) && Objects.equals(this.getClientAuthenticationFlow(), other.getClientAuthenticationFlow()) && Objects.equals(this.getClientInitialAccesses(), other.getClientInitialAccesses()) && Objects.equals(this.getClientOfflineSessionIdleTimeout(), other.getClientOfflineSessionIdleTimeout()) && Objects.equals(this.getClientOfflineSessionMaxLifespan(), other.getClientOfflineSessionMaxLifespan()) && Objects.equals(this.getClientSessionIdleTimeout(), other.getClientSessionIdleTimeout()) && Objects.equals(this.getClientSessionMaxLifespan(), other.getClientSessionMaxLifespan()) && Objects.equals(this.getComponents(), other.getComponents()) && Objects.equals(this.getDefaultClientScopeIds(), other.getDefaultClientScopeIds()) && Objects.equals(this.getDefaultGroupIds(), other.getDefaultGroupIds()) && Objects.equals(this.getDefaultLocale(), other.getDefaultLocale()) && Objects.equals(this.getDefaultRoleId(), other.getDefaultRoleId()) && Objects.equals(this.getDirectGrantFlow(), other.getDirectGrantFlow()) && Objects.equals(this.getDisplayName(), other.getDisplayName()) && Objects.equals(this.getDisplayNameHtml(), other.getDisplayNameHtml()) && Objects.equals(this.getDockerAuthenticationFlow(), other.getDockerAuthenticationFlow()) && Objects.equals(this.getEmailTheme(), other.getEmailTheme()) && Objects.equals(this.getEnabledEventTypes(), other.getEnabledEventTypes()) && Objects.equals(this.getEventsExpiration(), other.getEventsExpiration()) && Objects.equals(this.getEventsListeners(), other.getEventsListeners()) && Objects.equals(this.getIdentityProviderMappers(), other.getIdentityProviderMappers()) && Objects.equals(this.getIdentityProviders(), other.getIdentityProviders()) && Objects.equals(this.getLocalizationTexts(), other.getLocalizationTexts()) && Objects.equals(this.getLoginTheme(), other.getLoginTheme()) && Objects.equals(this.getMasterAdminClient(), other.getMasterAdminClient()) && Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getNotBefore(), other.getNotBefore()) && Objects.equals(this.getOTPPolicy(), other.getOTPPolicy()) && Objects.equals(this.getOfflineSessionIdleTimeout(), other.getOfflineSessionIdleTimeout()) && Objects.equals(this.getOfflineSessionMaxLifespan(), other.getOfflineSessionMaxLifespan()) && Objects.equals(this.getOptionalClientScopeIds(), other.getOptionalClientScopeIds()) && Objects.equals(this.getPasswordPolicy(), other.getPasswordPolicy()) && Objects.equals(this.getRefreshTokenMaxReuse(), other.getRefreshTokenMaxReuse()) && Objects.equals(this.getRegistrationFlow(), other.getRegistrationFlow()) && Objects.equals(this.getRequiredActionProviders(), other.getRequiredActionProviders()) && Objects.equals(this.getRequiredCredentials(), other.getRequiredCredentials()) && Objects.equals(this.getResetCredentialsFlow(), other.getResetCredentialsFlow()) && Objects.equals(this.getSmtpConfig(), other.getSmtpConfig()) && Objects.equals(this.getSslRequired(), other.getSslRequired()) && Objects.equals(this.getSsoSessionIdleTimeout(), other.getSsoSessionIdleTimeout()) && Objects.equals(this.getSsoSessionIdleTimeoutRememberMe(), other.getSsoSessionIdleTimeoutRememberMe()) && Objects.equals(this.getSsoSessionMaxLifespan(), other.getSsoSessionMaxLifespan()) && Objects.equals(this.getSsoSessionMaxLifespanRememberMe(), other.getSsoSessionMaxLifespanRememberMe()) && Objects.equals(this.getSupportedLocales(), other.getSupportedLocales()) && Objects.equals(this.getWebAuthnPolicy(), other.getWebAuthnPolicy()) && Objects.equals(this.getWebAuthnPolicyPasswordless(), other.getWebAuthnPolicyPasswordless()) && Objects.equals(this.isAdminEventsDetailsEnabled(), other.isAdminEventsDetailsEnabled()) && Objects.equals(this.isAdminEventsEnabled(), other.isAdminEventsEnabled()) && Objects.equals(this.isAllowUserManagedAccess(), other.isAllowUserManagedAccess()) && Objects.equals(this.isDuplicateEmailsAllowed(), other.isDuplicateEmailsAllowed()) && Objects.equals(this.isEditUsernameAllowed(), other.isEditUsernameAllowed()) && Objects.equals(this.isEnabled(), other.isEnabled()) && Objects.equals(this.isEventsEnabled(), other.isEventsEnabled()) && Objects.equals(this.isInternationalizationEnabled(), other.isInternationalizationEnabled()) && Objects.equals(this.isLoginWithEmailAllowed(), other.isLoginWithEmailAllowed()) && Objects.equals(this.isOfflineSessionMaxLifespanEnabled(), other.isOfflineSessionMaxLifespanEnabled()) && Objects.equals(this.isRegistrationAllowed(), other.isRegistrationAllowed()) && Objects.equals(this.isRegistrationEmailAsUsername(), other.isRegistrationEmailAsUsername()) && Objects.equals(this.isRememberMe(), other.isRememberMe()) && Objects.equals(this.isResetPasswordAllowed(), other.isResetPasswordAllowed()) && Objects.equals(this.isRevokeRefreshToken(), other.isRevokeRefreshToken()) && Objects.equals(this.isVerifyEmail(), other.isVerifyEmail());
    }

    public int hashCode() {
        return this.getId() == null ? super.hashCode() : this.getId().hashCode();
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }

    public static boolean entityEquals(Object o1, Object o2) {
        if (!(o1 instanceof HotRodRealmEntity)) {
            return false;
        }
        if (!(o2 instanceof HotRodRealmEntity)) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        HotRodRealmEntity e1 = (HotRodRealmEntity)o1;
        HotRodRealmEntity e2 = (HotRodRealmEntity)o2;
        return Objects.equals(e1.updated, e2.updated) && Objects.equals(e1.entityVersion, e2.entityVersion) && Objects.equals(e1.id, e2.id) && Objects.equals(e1.name, e2.name) && Objects.equals(e1.adminEventsDetailsEnabled, e2.adminEventsDetailsEnabled) && Objects.equals(e1.adminEventsEnabled, e2.adminEventsEnabled) && Objects.equals(e1.allowUserManagedAccess, e2.allowUserManagedAccess) && Objects.equals(e1.duplicateEmailsAllowed, e2.duplicateEmailsAllowed) && Objects.equals(e1.editUsernameAllowed, e2.editUsernameAllowed) && Objects.equals(e1.enabled, e2.enabled) && Objects.equals(e1.eventsEnabled, e2.eventsEnabled) && Objects.equals(e1.internationalizationEnabled, e2.internationalizationEnabled) && Objects.equals(e1.loginWithEmailAllowed, e2.loginWithEmailAllowed) && Objects.equals(e1.offlineSessionMaxLifespanEnabled, e2.offlineSessionMaxLifespanEnabled) && Objects.equals(e1.registrationAllowed, e2.registrationAllowed) && Objects.equals(e1.registrationEmailAsUsername, e2.registrationEmailAsUsername) && Objects.equals(e1.rememberMe, e2.rememberMe) && Objects.equals(e1.resetPasswordAllowed, e2.resetPasswordAllowed) && Objects.equals(e1.revokeRefreshToken, e2.revokeRefreshToken) && Objects.equals(e1.verifyEmail, e2.verifyEmail) && Objects.equals(e1.accessCodeLifespan, e2.accessCodeLifespan) && Objects.equals(e1.accessCodeLifespanLogin, e2.accessCodeLifespanLogin) && Objects.equals(e1.accessCodeLifespanUserAction, e2.accessCodeLifespanUserAction) && Objects.equals(e1.accessTokenLifespan, e2.accessTokenLifespan) && Objects.equals(e1.accessTokenLifespanForImplicitFlow, e2.accessTokenLifespanForImplicitFlow) && Objects.equals(e1.actionTokenGeneratedByAdminLifespan, e2.actionTokenGeneratedByAdminLifespan) && Objects.equals(e1.clientOfflineSessionIdleTimeout, e2.clientOfflineSessionIdleTimeout) && Objects.equals(e1.clientOfflineSessionMaxLifespan, e2.clientOfflineSessionMaxLifespan) && Objects.equals(e1.clientSessionIdleTimeout, e2.clientSessionIdleTimeout) && Objects.equals(e1.clientSessionMaxLifespan, e2.clientSessionMaxLifespan) && Objects.equals(e1.notBefore, e2.notBefore) && Objects.equals(e1.offlineSessionIdleTimeout, e2.offlineSessionIdleTimeout) && Objects.equals(e1.offlineSessionMaxLifespan, e2.offlineSessionMaxLifespan) && Objects.equals(e1.refreshTokenMaxReuse, e2.refreshTokenMaxReuse) && Objects.equals(e1.ssoSessionIdleTimeout, e2.ssoSessionIdleTimeout) && Objects.equals(e1.ssoSessionIdleTimeoutRememberMe, e2.ssoSessionIdleTimeoutRememberMe) && Objects.equals(e1.ssoSessionMaxLifespan, e2.ssoSessionMaxLifespan) && Objects.equals(e1.ssoSessionMaxLifespanRememberMe, e2.ssoSessionMaxLifespanRememberMe) && Objects.equals(e1.eventsExpiration, e2.eventsExpiration) && Objects.equals(e1.oTPPolicy, e2.oTPPolicy) && Objects.equals(e1.webAuthnPolicy, e2.webAuthnPolicy) && Objects.equals(e1.webAuthnPolicyPasswordless, e2.webAuthnPolicyPasswordless) && Objects.equals(e1.accountTheme, e2.accountTheme) && Objects.equals(e1.adminTheme, e2.adminTheme) && Objects.equals(e1.browserFlow, e2.browserFlow) && Objects.equals(e1.clientAuthenticationFlow, e2.clientAuthenticationFlow) && Objects.equals(e1.defaultLocale, e2.defaultLocale) && Objects.equals(e1.defaultRoleId, e2.defaultRoleId) && Objects.equals(e1.directGrantFlow, e2.directGrantFlow) && Objects.equals(e1.displayName, e2.displayName) && Objects.equals(e1.displayNameHtml, e2.displayNameHtml) && Objects.equals(e1.dockerAuthenticationFlow, e2.dockerAuthenticationFlow) && Objects.equals(e1.emailTheme, e2.emailTheme) && Objects.equals(e1.loginTheme, e2.loginTheme) && Objects.equals(e1.masterAdminClient, e2.masterAdminClient) && Objects.equals(e1.passwordPolicy, e2.passwordPolicy) && Objects.equals(e1.registrationFlow, e2.registrationFlow) && Objects.equals(e1.resetCredentialsFlow, e2.resetCredentialsFlow) && Objects.equals(e1.sslRequired, e2.sslRequired) && Objects.equals(e1.attributes, e2.attributes) && Objects.equals(e1.localizationTexts, e2.localizationTexts) && Objects.equals(e1.browserSecurityHeaders, e2.browserSecurityHeaders) && Objects.equals(e1.smtpConfig, e2.smtpConfig) && Objects.equals(e1.authenticationExecutions, e2.authenticationExecutions) && Objects.equals(e1.authenticationFlows, e2.authenticationFlows) && Objects.equals(e1.authenticatorConfigs, e2.authenticatorConfigs) && Objects.equals(e1.clientInitialAccesses, e2.clientInitialAccesses) && Objects.equals(e1.components, e2.components) && Objects.equals(e1.identityProviders, e2.identityProviders) && Objects.equals(e1.identityProviderMappers, e2.identityProviderMappers) && Objects.equals(e1.requiredActionProviders, e2.requiredActionProviders) && Objects.equals(e1.requiredCredentials, e2.requiredCredentials) && Objects.equals(e1.defaultClientScopeIds, e2.defaultClientScopeIds) && Objects.equals(e1.defaultGroupIds, e2.defaultGroupIds) && Objects.equals(e1.enabledEventTypes, e2.enabledEventTypes) && Objects.equals(e1.eventsListeners, e2.eventsListeners) && Objects.equals(e1.optionalClientScopeIds, e2.optionalClientScopeIds) && Objects.equals(e1.supportedLocales, e2.supportedLocales);
    }

    public static int entityHashCode(HotRodRealmEntity e) {
        return e.id == null ? Objects.hash(e) : e.id.hashCode();
    }

    public <V> V deepClone(V obj) {
        return (V)this.cloner.from(obj);
    }

    public Integer getAccessCodeLifespan() {
        return this.hotRodEntity.accessCodeLifespan == null ? null : this.hotRodEntity.accessCodeLifespan;
    }

    public void setAccessCodeLifespan(Integer p0) {
        Integer migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.accessCodeLifespan, migrated);
        this.hotRodEntity.accessCodeLifespan = migrated;
    }

    public Integer getAccessCodeLifespanLogin() {
        return this.hotRodEntity.accessCodeLifespanLogin == null ? null : this.hotRodEntity.accessCodeLifespanLogin;
    }

    public void setAccessCodeLifespanLogin(Integer p0) {
        Integer migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.accessCodeLifespanLogin, migrated);
        this.hotRodEntity.accessCodeLifespanLogin = migrated;
    }

    public Integer getAccessCodeLifespanUserAction() {
        return this.hotRodEntity.accessCodeLifespanUserAction == null ? null : this.hotRodEntity.accessCodeLifespanUserAction;
    }

    public void setAccessCodeLifespanUserAction(Integer p0) {
        Integer migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.accessCodeLifespanUserAction, migrated);
        this.hotRodEntity.accessCodeLifespanUserAction = migrated;
    }

    public void setAccessTokenLifespan(Integer p0) {
        Integer migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.accessTokenLifespan, migrated);
        this.hotRodEntity.accessTokenLifespan = migrated;
    }

    public Integer getAccessTokenLifespan() {
        return this.hotRodEntity.accessTokenLifespan == null ? null : this.hotRodEntity.accessTokenLifespan;
    }

    public Integer getAccessTokenLifespanForImplicitFlow() {
        return this.hotRodEntity.accessTokenLifespanForImplicitFlow == null ? null : this.hotRodEntity.accessTokenLifespanForImplicitFlow;
    }

    public void setAccessTokenLifespanForImplicitFlow(Integer p0) {
        Integer migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.accessTokenLifespanForImplicitFlow, migrated);
        this.hotRodEntity.accessTokenLifespanForImplicitFlow = migrated;
    }

    public void setAccountTheme(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.accountTheme, migrated);
        this.hotRodEntity.accountTheme = migrated;
    }

    public String getAccountTheme() {
        return this.hotRodEntity.accountTheme == null ? null : this.hotRodEntity.accountTheme;
    }

    public Integer getActionTokenGeneratedByAdminLifespan() {
        return this.hotRodEntity.actionTokenGeneratedByAdminLifespan == null ? null : this.hotRodEntity.actionTokenGeneratedByAdminLifespan;
    }

    public void setActionTokenGeneratedByAdminLifespan(Integer p0) {
        Integer migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.actionTokenGeneratedByAdminLifespan, migrated);
        this.hotRodEntity.actionTokenGeneratedByAdminLifespan = migrated;
    }

    public Boolean isAdminEventsDetailsEnabled() {
        return this.hotRodEntity.adminEventsDetailsEnabled == null ? null : this.hotRodEntity.adminEventsDetailsEnabled;
    }

    public void setAdminEventsDetailsEnabled(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.adminEventsDetailsEnabled, migrated);
        this.hotRodEntity.adminEventsDetailsEnabled = migrated;
    }

    public Boolean isAdminEventsEnabled() {
        return this.hotRodEntity.adminEventsEnabled == null ? null : this.hotRodEntity.adminEventsEnabled;
    }

    public void setAdminEventsEnabled(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.adminEventsEnabled, migrated);
        this.hotRodEntity.adminEventsEnabled = migrated;
    }

    public String getAdminTheme() {
        return this.hotRodEntity.adminTheme == null ? null : this.hotRodEntity.adminTheme;
    }

    public void setAdminTheme(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.adminTheme, migrated);
        this.hotRodEntity.adminTheme = migrated;
    }

    public void setAllowUserManagedAccess(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.allowUserManagedAccess, migrated);
        this.hotRodEntity.allowUserManagedAccess = migrated;
    }

    public Boolean isAllowUserManagedAccess() {
        return this.hotRodEntity.allowUserManagedAccess == null ? null : this.hotRodEntity.allowUserManagedAccess;
    }

    public List<String> getAttribute(String p0) {
        return HotRodTypesUtils.getMapValueFromSet(this.hotRodEntity.attributes, p0, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public void setAttributes(Map<String, List<String>> p0) {
        Map<String, List<String>> map = p0 = p0 == null ? null : (Map<String, List<String>>)p0.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue() == null ? null : new LinkedList((Collection)entry.getValue()), (o1, o2) -> o1, HashMap::new));
        if (p0 != null) {
            p0.values().removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        Set<HotRodAttributeEntityNonIndexed> migrated = p0 == null ? null : HotRodTypesUtils.migrateMapToSet(p0, HotRodTypesUtils::createHotRodAttributeEntityNonIndexedFromMapEntry);
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.attributes, migrated);
        this.hotRodEntity.attributes = migrated;
    }

    public Map<String, List<String>> getAttributes() {
        return this.hotRodEntity.attributes == null ? null : HotRodTypesUtils.migrateSetToMap(this.hotRodEntity.attributes, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public void removeAttribute(String p0) {
        boolean removed = HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.attributes, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated |= removed;
    }

    public void setAttribute(String p0, List<String> p1) {
        LinkedList<String> linkedList = p1 = p1 == null ? null : new LinkedList<String>(p1);
        if (p1 != null) {
            p1.removeIf(UndefinedValuesUtils::isUndefined);
        }
        boolean valueUndefined = UndefinedValuesUtils.isUndefined(p1);
        if (this.hotRodEntity.attributes == null && !valueUndefined) {
            this.hotRodEntity.attributes = new HashSet<HotRodAttributeEntityNonIndexed>();
        }
        this.hotRodEntity.updated |= HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.attributes, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated = this.hotRodEntity.updated | (!valueUndefined && this.hotRodEntity.attributes.add(new HotRodAttributeEntityNonIndexed(p0, p1)));
    }

    public Optional<MapAuthenticationExecutionEntity> getAuthenticationExecution(String p0) {
        if (this.hotRodEntity.authenticationExecutions == null || this.hotRodEntity.authenticationExecutions.isEmpty()) {
            return Optional.empty();
        }
        return this.hotRodEntity.authenticationExecutions.stream().filter(o -> Objects.equals(o.id, p0)).findFirst().map(e -> new HotRodAuthenticationExecutionEntityDelegate((HotRodAuthenticationExecutionEntity)e));
    }

    public Boolean removeAuthenticationExecution(String p0) {
        boolean removed = this.hotRodEntity.authenticationExecutions != null && this.hotRodEntity.authenticationExecutions.removeIf(o -> Objects.equals(o.id, p0));
        this.hotRodEntity.updated |= removed;
        return removed;
    }

    public void addAuthenticationExecution(MapAuthenticationExecutionEntity p0) {
        if (UndefinedValuesUtils.isUndefined((Object)(p0 = this.deepClone(p0)))) {
            return;
        }
        if (this.hotRodEntity.authenticationExecutions == null) {
            this.hotRodEntity.authenticationExecutions = new HashSet<HotRodAuthenticationExecutionEntity>();
        }
        HotRodAuthenticationExecutionEntity migrated = (HotRodAuthenticationExecutionEntity)((HotRodEntityDelegate)p0).getHotRodEntity();
        this.hotRodEntity.updated |= this.hotRodEntity.authenticationExecutions.add(migrated);
    }

    public Set<MapAuthenticationExecutionEntity> getAuthenticationExecutions() {
        return this.hotRodEntity.authenticationExecutions == null ? null : HotRodTypesUtils.migrateSet(this.hotRodEntity.authenticationExecutions, collectionItem -> new HotRodAuthenticationExecutionEntityDelegate((HotRodAuthenticationExecutionEntity)collectionItem));
    }

    public Optional<MapAuthenticationFlowEntity> getAuthenticationFlow(String p0) {
        if (this.hotRodEntity.authenticationFlows == null || this.hotRodEntity.authenticationFlows.isEmpty()) {
            return Optional.empty();
        }
        return this.hotRodEntity.authenticationFlows.stream().filter(o -> Objects.equals(o.id, p0)).findFirst().map(e -> new HotRodAuthenticationFlowEntityDelegate((HotRodAuthenticationFlowEntity)e));
    }

    public Boolean removeAuthenticationFlow(String p0) {
        boolean removed = this.hotRodEntity.authenticationFlows != null && this.hotRodEntity.authenticationFlows.removeIf(o -> Objects.equals(o.id, p0));
        this.hotRodEntity.updated |= removed;
        return removed;
    }

    public Set<MapAuthenticationFlowEntity> getAuthenticationFlows() {
        return this.hotRodEntity.authenticationFlows == null ? null : HotRodTypesUtils.migrateSet(this.hotRodEntity.authenticationFlows, collectionItem -> new HotRodAuthenticationFlowEntityDelegate((HotRodAuthenticationFlowEntity)collectionItem));
    }

    public void addAuthenticationFlow(MapAuthenticationFlowEntity p0) {
        if (UndefinedValuesUtils.isUndefined((Object)(p0 = this.deepClone(p0)))) {
            return;
        }
        if (this.hotRodEntity.authenticationFlows == null) {
            this.hotRodEntity.authenticationFlows = new HashSet<HotRodAuthenticationFlowEntity>();
        }
        HotRodAuthenticationFlowEntity migrated = (HotRodAuthenticationFlowEntity)((HotRodEntityDelegate)p0).getHotRodEntity();
        this.hotRodEntity.updated |= this.hotRodEntity.authenticationFlows.add(migrated);
    }

    public void addAuthenticatorConfig(MapAuthenticatorConfigEntity p0) {
        if (UndefinedValuesUtils.isUndefined((Object)(p0 = this.deepClone(p0)))) {
            return;
        }
        if (this.hotRodEntity.authenticatorConfigs == null) {
            this.hotRodEntity.authenticatorConfigs = new HashSet<HotRodAuthenticatorConfigEntity>();
        }
        HotRodAuthenticatorConfigEntity migrated = (HotRodAuthenticatorConfigEntity)((HotRodEntityDelegate)p0).getHotRodEntity();
        this.hotRodEntity.updated |= this.hotRodEntity.authenticatorConfigs.add(migrated);
    }

    public Boolean removeAuthenticatorConfig(String p0) {
        boolean removed = this.hotRodEntity.authenticatorConfigs != null && this.hotRodEntity.authenticatorConfigs.removeIf(o -> Objects.equals(o.id, p0));
        this.hotRodEntity.updated |= removed;
        return removed;
    }

    public Optional<MapAuthenticatorConfigEntity> getAuthenticatorConfig(String p0) {
        if (this.hotRodEntity.authenticatorConfigs == null || this.hotRodEntity.authenticatorConfigs.isEmpty()) {
            return Optional.empty();
        }
        return this.hotRodEntity.authenticatorConfigs.stream().filter(o -> Objects.equals(o.id, p0)).findFirst().map(e -> new HotRodAuthenticatorConfigEntityDelegate((HotRodAuthenticatorConfigEntity)e));
    }

    public Set<MapAuthenticatorConfigEntity> getAuthenticatorConfigs() {
        return this.hotRodEntity.authenticatorConfigs == null ? null : HotRodTypesUtils.migrateSet(this.hotRodEntity.authenticatorConfigs, collectionItem -> new HotRodAuthenticatorConfigEntityDelegate((HotRodAuthenticatorConfigEntity)collectionItem));
    }

    public String getBrowserFlow() {
        return this.hotRodEntity.browserFlow == null ? null : this.hotRodEntity.browserFlow;
    }

    public void setBrowserFlow(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.browserFlow, migrated);
        this.hotRodEntity.browserFlow = migrated;
    }

    public Map<String, String> getBrowserSecurityHeaders() {
        return this.hotRodEntity.browserSecurityHeaders == null ? null : HotRodTypesUtils.migrateSetToMap(this.hotRodEntity.browserSecurityHeaders, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public void setBrowserSecurityHeader(String p0, String p1) {
        boolean valueUndefined = UndefinedValuesUtils.isUndefined((Object)p1);
        if (this.hotRodEntity.browserSecurityHeaders == null && !valueUndefined) {
            this.hotRodEntity.browserSecurityHeaders = new HashSet<HotRodPair<String, String>>();
        }
        this.hotRodEntity.updated |= HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.browserSecurityHeaders, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated = this.hotRodEntity.updated | (!valueUndefined && this.hotRodEntity.browserSecurityHeaders.add(new HotRodPair<String, String>(p0, p1)));
    }

    public void setBrowserSecurityHeaders(Map<String, String> p0) {
        HashMap hashMap = p0 = p0 == null ? null : new HashMap(p0);
        if (p0 != null) {
            p0.values().removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        Set<HotRodPair> migrated = p0 == null ? null : HotRodTypesUtils.migrateMapToSet(p0, HotRodTypesUtils::createHotRodPairFromMapEntry);
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.browserSecurityHeaders, migrated);
        this.hotRodEntity.browserSecurityHeaders = migrated;
    }

    public String getClientAuthenticationFlow() {
        return this.hotRodEntity.clientAuthenticationFlow == null ? null : this.hotRodEntity.clientAuthenticationFlow;
    }

    public void setClientAuthenticationFlow(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.clientAuthenticationFlow, migrated);
        this.hotRodEntity.clientAuthenticationFlow = migrated;
    }

    public Optional<MapClientInitialAccessEntity> getClientInitialAccess(String p0) {
        if (this.hotRodEntity.clientInitialAccesses == null || this.hotRodEntity.clientInitialAccesses.isEmpty()) {
            return Optional.empty();
        }
        return this.hotRodEntity.clientInitialAccesses.stream().filter(o -> Objects.equals(o.id, p0)).findFirst().map(e -> new HotRodClientInitialAccessEntityDelegate((HotRodClientInitialAccessEntity)e));
    }

    public Boolean removeClientInitialAccess(String p0) {
        boolean removed = this.hotRodEntity.clientInitialAccesses != null && this.hotRodEntity.clientInitialAccesses.removeIf(o -> Objects.equals(o.id, p0));
        this.hotRodEntity.updated |= removed;
        return removed;
    }

    public Set<MapClientInitialAccessEntity> getClientInitialAccesses() {
        return this.hotRodEntity.clientInitialAccesses == null ? null : HotRodTypesUtils.migrateSet(this.hotRodEntity.clientInitialAccesses, collectionItem -> new HotRodClientInitialAccessEntityDelegate((HotRodClientInitialAccessEntity)collectionItem));
    }

    public void addClientInitialAccess(MapClientInitialAccessEntity p0) {
        if (UndefinedValuesUtils.isUndefined((Object)(p0 = this.deepClone(p0)))) {
            return;
        }
        if (this.hotRodEntity.clientInitialAccesses == null) {
            this.hotRodEntity.clientInitialAccesses = new HashSet<HotRodClientInitialAccessEntity>();
        }
        HotRodClientInitialAccessEntity migrated = (HotRodClientInitialAccessEntity)((HotRodEntityDelegate)p0).getHotRodEntity();
        this.hotRodEntity.updated |= this.hotRodEntity.clientInitialAccesses.add(migrated);
    }

    public Integer getClientOfflineSessionIdleTimeout() {
        return this.hotRodEntity.clientOfflineSessionIdleTimeout == null ? null : this.hotRodEntity.clientOfflineSessionIdleTimeout;
    }

    public void setClientOfflineSessionIdleTimeout(Integer p0) {
        Integer migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.clientOfflineSessionIdleTimeout, migrated);
        this.hotRodEntity.clientOfflineSessionIdleTimeout = migrated;
    }

    public void setClientOfflineSessionMaxLifespan(Integer p0) {
        Integer migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.clientOfflineSessionMaxLifespan, migrated);
        this.hotRodEntity.clientOfflineSessionMaxLifespan = migrated;
    }

    public Integer getClientOfflineSessionMaxLifespan() {
        return this.hotRodEntity.clientOfflineSessionMaxLifespan == null ? null : this.hotRodEntity.clientOfflineSessionMaxLifespan;
    }

    public Integer getClientSessionIdleTimeout() {
        return this.hotRodEntity.clientSessionIdleTimeout == null ? null : this.hotRodEntity.clientSessionIdleTimeout;
    }

    public void setClientSessionIdleTimeout(Integer p0) {
        Integer migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.clientSessionIdleTimeout, migrated);
        this.hotRodEntity.clientSessionIdleTimeout = migrated;
    }

    public Integer getClientSessionMaxLifespan() {
        return this.hotRodEntity.clientSessionMaxLifespan == null ? null : this.hotRodEntity.clientSessionMaxLifespan;
    }

    public void setClientSessionMaxLifespan(Integer p0) {
        Integer migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.clientSessionMaxLifespan, migrated);
        this.hotRodEntity.clientSessionMaxLifespan = migrated;
    }

    public void addComponent(MapComponentEntity p0) {
        if (UndefinedValuesUtils.isUndefined((Object)(p0 = this.deepClone(p0)))) {
            return;
        }
        if (this.hotRodEntity.components == null) {
            this.hotRodEntity.components = new HashSet<HotRodComponentEntity>();
        }
        HotRodComponentEntity migrated = (HotRodComponentEntity)((HotRodEntityDelegate)p0).getHotRodEntity();
        this.hotRodEntity.updated |= this.hotRodEntity.components.add(migrated);
    }

    public Boolean removeComponent(String p0) {
        boolean removed = this.hotRodEntity.components != null && this.hotRodEntity.components.removeIf(o -> Objects.equals(o.id, p0));
        this.hotRodEntity.updated |= removed;
        return removed;
    }

    public Set<MapComponentEntity> getComponents() {
        return this.hotRodEntity.components == null ? null : HotRodTypesUtils.migrateSet(this.hotRodEntity.components, collectionItem -> new HotRodComponentEntityDelegate((HotRodComponentEntity)collectionItem));
    }

    public Optional<MapComponentEntity> getComponent(String p0) {
        if (this.hotRodEntity.components == null || this.hotRodEntity.components.isEmpty()) {
            return Optional.empty();
        }
        return this.hotRodEntity.components.stream().filter(o -> Objects.equals(o.id, p0)).findFirst().map(e -> new HotRodComponentEntityDelegate((HotRodComponentEntity)e));
    }

    public Set<String> getDefaultClientScopeIds() {
        return this.hotRodEntity.defaultClientScopeIds == null ? null : this.hotRodEntity.defaultClientScopeIds;
    }

    public void addDefaultClientScopeId(String p0) {
        if (UndefinedValuesUtils.isUndefined((Object)p0)) {
            return;
        }
        if (this.hotRodEntity.defaultClientScopeIds == null) {
            this.hotRodEntity.defaultClientScopeIds = new HashSet<String>();
        }
        String migrated = p0;
        this.hotRodEntity.updated |= this.hotRodEntity.defaultClientScopeIds.add(migrated);
    }

    public Boolean removeDefaultClientScopeId(String p0) {
        if (this.hotRodEntity.defaultClientScopeIds == null) {
            return false;
        }
        boolean removed = this.hotRodEntity.defaultClientScopeIds.remove(p0);
        this.hotRodEntity.updated |= removed;
        return removed;
    }

    public Set<String> getDefaultGroupIds() {
        return this.hotRodEntity.defaultGroupIds == null ? null : this.hotRodEntity.defaultGroupIds;
    }

    public void addDefaultGroupId(String p0) {
        if (UndefinedValuesUtils.isUndefined((Object)p0)) {
            return;
        }
        if (this.hotRodEntity.defaultGroupIds == null) {
            this.hotRodEntity.defaultGroupIds = new HashSet<String>();
        }
        String migrated = p0;
        this.hotRodEntity.updated |= this.hotRodEntity.defaultGroupIds.add(migrated);
    }

    public void removeDefaultGroupId(String p0) {
        if (this.hotRodEntity.defaultGroupIds == null) {
            return;
        }
        boolean removed = this.hotRodEntity.defaultGroupIds.remove(p0);
        this.hotRodEntity.updated |= removed;
    }

    public String getDefaultLocale() {
        return this.hotRodEntity.defaultLocale == null ? null : this.hotRodEntity.defaultLocale;
    }

    public void setDefaultLocale(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.defaultLocale, migrated);
        this.hotRodEntity.defaultLocale = migrated;
    }

    public String getDefaultRoleId() {
        return this.hotRodEntity.defaultRoleId == null ? null : this.hotRodEntity.defaultRoleId;
    }

    public void setDefaultRoleId(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.defaultRoleId, migrated);
        this.hotRodEntity.defaultRoleId = migrated;
    }

    public String getDirectGrantFlow() {
        return this.hotRodEntity.directGrantFlow == null ? null : this.hotRodEntity.directGrantFlow;
    }

    public void setDirectGrantFlow(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.directGrantFlow, migrated);
        this.hotRodEntity.directGrantFlow = migrated;
    }

    public void setDisplayName(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.displayName, migrated);
        this.hotRodEntity.displayName = migrated;
    }

    public String getDisplayName() {
        return this.hotRodEntity.displayName == null ? null : this.hotRodEntity.displayName;
    }

    public void setDisplayNameHtml(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.displayNameHtml, migrated);
        this.hotRodEntity.displayNameHtml = migrated;
    }

    public String getDisplayNameHtml() {
        return this.hotRodEntity.displayNameHtml == null ? null : this.hotRodEntity.displayNameHtml;
    }

    public String getDockerAuthenticationFlow() {
        return this.hotRodEntity.dockerAuthenticationFlow == null ? null : this.hotRodEntity.dockerAuthenticationFlow;
    }

    public void setDockerAuthenticationFlow(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.dockerAuthenticationFlow, migrated);
        this.hotRodEntity.dockerAuthenticationFlow = migrated;
    }

    public Boolean isDuplicateEmailsAllowed() {
        return this.hotRodEntity.duplicateEmailsAllowed == null ? null : this.hotRodEntity.duplicateEmailsAllowed;
    }

    public void setDuplicateEmailsAllowed(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.duplicateEmailsAllowed, migrated);
        this.hotRodEntity.duplicateEmailsAllowed = migrated;
    }

    public Boolean isEditUsernameAllowed() {
        return this.hotRodEntity.editUsernameAllowed == null ? null : this.hotRodEntity.editUsernameAllowed;
    }

    public void setEditUsernameAllowed(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.editUsernameAllowed, migrated);
        this.hotRodEntity.editUsernameAllowed = migrated;
    }

    public void setEmailTheme(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.emailTheme, migrated);
        this.hotRodEntity.emailTheme = migrated;
    }

    public String getEmailTheme() {
        return this.hotRodEntity.emailTheme == null ? null : this.hotRodEntity.emailTheme;
    }

    public void setEnabled(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.enabled, migrated);
        this.hotRodEntity.enabled = migrated;
    }

    public Boolean isEnabled() {
        return this.hotRodEntity.enabled == null ? null : this.hotRodEntity.enabled;
    }

    public Set<String> getEnabledEventTypes() {
        return this.hotRodEntity.enabledEventTypes == null ? null : this.hotRodEntity.enabledEventTypes;
    }

    public void setEnabledEventTypes(Set<String> p0) {
        HashSet<String> hashSet = p0 = p0 == null ? null : new HashSet<String>(p0);
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        HashSet<String> migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.enabledEventTypes, migrated);
        this.hotRodEntity.enabledEventTypes = migrated;
    }

    public void setEventsEnabled(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.eventsEnabled, migrated);
        this.hotRodEntity.eventsEnabled = migrated;
    }

    public Boolean isEventsEnabled() {
        return this.hotRodEntity.eventsEnabled == null ? null : this.hotRodEntity.eventsEnabled;
    }

    public Long getEventsExpiration() {
        return this.hotRodEntity.eventsExpiration == null ? null : this.hotRodEntity.eventsExpiration;
    }

    public void setEventsExpiration(Long p0) {
        Long migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.eventsExpiration, migrated);
        this.hotRodEntity.eventsExpiration = migrated;
    }

    public void setEventsListeners(Set<String> p0) {
        HashSet<String> hashSet = p0 = p0 == null ? null : new HashSet<String>(p0);
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        HashSet<String> migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.eventsListeners, migrated);
        this.hotRodEntity.eventsListeners = migrated;
    }

    public Set<String> getEventsListeners() {
        return this.hotRodEntity.eventsListeners == null ? null : this.hotRodEntity.eventsListeners;
    }

    public Set<MapIdentityProviderMapperEntity> getIdentityProviderMappers() {
        return this.hotRodEntity.identityProviderMappers == null ? null : HotRodTypesUtils.migrateSet(this.hotRodEntity.identityProviderMappers, collectionItem -> new HotRodIdentityProviderMapperEntityDelegate((HotRodIdentityProviderMapperEntity)collectionItem));
    }

    public Optional<MapIdentityProviderMapperEntity> getIdentityProviderMapper(String p0) {
        if (this.hotRodEntity.identityProviderMappers == null || this.hotRodEntity.identityProviderMappers.isEmpty()) {
            return Optional.empty();
        }
        return this.hotRodEntity.identityProviderMappers.stream().filter(o -> Objects.equals(o.id, p0)).findFirst().map(e -> new HotRodIdentityProviderMapperEntityDelegate((HotRodIdentityProviderMapperEntity)e));
    }

    public void addIdentityProviderMapper(MapIdentityProviderMapperEntity p0) {
        if (UndefinedValuesUtils.isUndefined((Object)(p0 = this.deepClone(p0)))) {
            return;
        }
        if (this.hotRodEntity.identityProviderMappers == null) {
            this.hotRodEntity.identityProviderMappers = new HashSet<HotRodIdentityProviderMapperEntity>();
        }
        HotRodIdentityProviderMapperEntity migrated = (HotRodIdentityProviderMapperEntity)((HotRodEntityDelegate)p0).getHotRodEntity();
        this.hotRodEntity.updated |= this.hotRodEntity.identityProviderMappers.add(migrated);
    }

    public Boolean removeIdentityProviderMapper(String p0) {
        boolean removed = this.hotRodEntity.identityProviderMappers != null && this.hotRodEntity.identityProviderMappers.removeIf(o -> Objects.equals(o.id, p0));
        this.hotRodEntity.updated |= removed;
        return removed;
    }

    public Set<MapIdentityProviderEntity> getIdentityProviders() {
        return this.hotRodEntity.identityProviders == null ? null : HotRodTypesUtils.migrateSet(this.hotRodEntity.identityProviders, collectionItem -> new HotRodIdentityProviderEntityDelegate((HotRodIdentityProviderEntity)collectionItem));
    }

    public void addIdentityProvider(MapIdentityProviderEntity p0) {
        if (UndefinedValuesUtils.isUndefined((Object)(p0 = this.deepClone(p0)))) {
            return;
        }
        if (this.hotRodEntity.identityProviders == null) {
            this.hotRodEntity.identityProviders = new HashSet<HotRodIdentityProviderEntity>();
        }
        HotRodIdentityProviderEntity migrated = (HotRodIdentityProviderEntity)((HotRodEntityDelegate)p0).getHotRodEntity();
        this.hotRodEntity.updated |= this.hotRodEntity.identityProviders.add(migrated);
    }

    public Boolean removeIdentityProvider(String p0) {
        boolean removed = this.hotRodEntity.identityProviders != null && this.hotRodEntity.identityProviders.removeIf(o -> Objects.equals(o.id, p0));
        this.hotRodEntity.updated |= removed;
        return removed;
    }

    public Boolean isInternationalizationEnabled() {
        return this.hotRodEntity.internationalizationEnabled == null ? null : this.hotRodEntity.internationalizationEnabled;
    }

    public void setInternationalizationEnabled(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.internationalizationEnabled, migrated);
        this.hotRodEntity.internationalizationEnabled = migrated;
    }

    public Boolean removeLocalizationText(String p0) {
        boolean removed = HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.localizationTexts, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated |= removed;
        return removed;
    }

    public void setLocalizationText(String p0, Map<String, String> p1) {
        HashMap<String, String> hashMap = p1 = p1 == null ? null : new HashMap<String, String>(p1);
        if (p1 != null) {
            p1.values().removeIf(UndefinedValuesUtils::isUndefined);
        }
        boolean valueUndefined = UndefinedValuesUtils.isUndefined(p1);
        if (this.hotRodEntity.localizationTexts == null && !valueUndefined) {
            this.hotRodEntity.localizationTexts = new HashSet<HotRodLocalizationTexts>();
        }
        this.hotRodEntity.updated |= HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.localizationTexts, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated = this.hotRodEntity.updated | (!valueUndefined && this.hotRodEntity.localizationTexts.add(HotRodTypesUtils.migrateStringMapToHotRodLocalizationTexts(p0, p1)));
    }

    public Map<String, String> getLocalizationText(String p0) {
        return HotRodTypesUtils.getMapValueFromSet(this.hotRodEntity.localizationTexts, p0, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public Map<String, Map<String, String>> getLocalizationTexts() {
        return this.hotRodEntity.localizationTexts == null ? null : HotRodTypesUtils.migrateSetToMap(this.hotRodEntity.localizationTexts, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public String getLoginTheme() {
        return this.hotRodEntity.loginTheme == null ? null : this.hotRodEntity.loginTheme;
    }

    public void setLoginTheme(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.loginTheme, migrated);
        this.hotRodEntity.loginTheme = migrated;
    }

    public void setLoginWithEmailAllowed(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.loginWithEmailAllowed, migrated);
        this.hotRodEntity.loginWithEmailAllowed = migrated;
    }

    public Boolean isLoginWithEmailAllowed() {
        return this.hotRodEntity.loginWithEmailAllowed == null ? null : this.hotRodEntity.loginWithEmailAllowed;
    }

    public void setMasterAdminClient(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.masterAdminClient, migrated);
        this.hotRodEntity.masterAdminClient = migrated;
    }

    public String getMasterAdminClient() {
        return this.hotRodEntity.masterAdminClient == null ? null : this.hotRodEntity.masterAdminClient;
    }

    public void setName(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.name, migrated);
        this.hotRodEntity.name = migrated;
    }

    public String getName() {
        return this.hotRodEntity.name == null ? null : this.hotRodEntity.name;
    }

    public void setNotBefore(Long p0) {
        Long migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.notBefore, migrated);
        this.hotRodEntity.notBefore = migrated;
    }

    public Long getNotBefore() {
        return this.hotRodEntity.notBefore == null ? null : this.hotRodEntity.notBefore;
    }

    public void setOTPPolicy(MapOTPPolicyEntity p0) {
        HotRodOTPPolicyEntity migrated = (p0 = this.deepClone(p0)) == null ? null : (HotRodOTPPolicyEntity)((HotRodEntityDelegate)p0).getHotRodEntity();
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.oTPPolicy, migrated);
        this.hotRodEntity.oTPPolicy = migrated;
    }

    public MapOTPPolicyEntity getOTPPolicy() {
        return this.hotRodEntity.oTPPolicy == null ? null : new HotRodOTPPolicyEntityDelegate(this.hotRodEntity.oTPPolicy);
    }

    public void setOfflineSessionIdleTimeout(Integer p0) {
        Integer migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.offlineSessionIdleTimeout, migrated);
        this.hotRodEntity.offlineSessionIdleTimeout = migrated;
    }

    public Integer getOfflineSessionIdleTimeout() {
        return this.hotRodEntity.offlineSessionIdleTimeout == null ? null : this.hotRodEntity.offlineSessionIdleTimeout;
    }

    public Integer getOfflineSessionMaxLifespan() {
        return this.hotRodEntity.offlineSessionMaxLifespan == null ? null : this.hotRodEntity.offlineSessionMaxLifespan;
    }

    public void setOfflineSessionMaxLifespan(Integer p0) {
        Integer migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.offlineSessionMaxLifespan, migrated);
        this.hotRodEntity.offlineSessionMaxLifespan = migrated;
    }

    public void setOfflineSessionMaxLifespanEnabled(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.offlineSessionMaxLifespanEnabled, migrated);
        this.hotRodEntity.offlineSessionMaxLifespanEnabled = migrated;
    }

    public Boolean isOfflineSessionMaxLifespanEnabled() {
        return this.hotRodEntity.offlineSessionMaxLifespanEnabled == null ? null : this.hotRodEntity.offlineSessionMaxLifespanEnabled;
    }

    public void addOptionalClientScopeId(String p0) {
        if (UndefinedValuesUtils.isUndefined((Object)p0)) {
            return;
        }
        if (this.hotRodEntity.optionalClientScopeIds == null) {
            this.hotRodEntity.optionalClientScopeIds = new HashSet<String>();
        }
        String migrated = p0;
        this.hotRodEntity.updated |= this.hotRodEntity.optionalClientScopeIds.add(migrated);
    }

    public Boolean removeOptionalClientScopeId(String p0) {
        if (this.hotRodEntity.optionalClientScopeIds == null) {
            return false;
        }
        boolean removed = this.hotRodEntity.optionalClientScopeIds.remove(p0);
        this.hotRodEntity.updated |= removed;
        return removed;
    }

    public Set<String> getOptionalClientScopeIds() {
        return this.hotRodEntity.optionalClientScopeIds == null ? null : this.hotRodEntity.optionalClientScopeIds;
    }

    public void setPasswordPolicy(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.passwordPolicy, migrated);
        this.hotRodEntity.passwordPolicy = migrated;
    }

    public String getPasswordPolicy() {
        return this.hotRodEntity.passwordPolicy == null ? null : this.hotRodEntity.passwordPolicy;
    }

    public void setRefreshTokenMaxReuse(Integer p0) {
        Integer migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.refreshTokenMaxReuse, migrated);
        this.hotRodEntity.refreshTokenMaxReuse = migrated;
    }

    public Integer getRefreshTokenMaxReuse() {
        return this.hotRodEntity.refreshTokenMaxReuse == null ? null : this.hotRodEntity.refreshTokenMaxReuse;
    }

    public void setRegistrationAllowed(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.registrationAllowed, migrated);
        this.hotRodEntity.registrationAllowed = migrated;
    }

    public Boolean isRegistrationAllowed() {
        return this.hotRodEntity.registrationAllowed == null ? null : this.hotRodEntity.registrationAllowed;
    }

    public void setRegistrationEmailAsUsername(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.registrationEmailAsUsername, migrated);
        this.hotRodEntity.registrationEmailAsUsername = migrated;
    }

    public Boolean isRegistrationEmailAsUsername() {
        return this.hotRodEntity.registrationEmailAsUsername == null ? null : this.hotRodEntity.registrationEmailAsUsername;
    }

    public void setRegistrationFlow(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.registrationFlow, migrated);
        this.hotRodEntity.registrationFlow = migrated;
    }

    public String getRegistrationFlow() {
        return this.hotRodEntity.registrationFlow == null ? null : this.hotRodEntity.registrationFlow;
    }

    public void setRememberMe(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.rememberMe, migrated);
        this.hotRodEntity.rememberMe = migrated;
    }

    public Boolean isRememberMe() {
        return this.hotRodEntity.rememberMe == null ? null : this.hotRodEntity.rememberMe;
    }

    public Boolean removeRequiredActionProvider(String p0) {
        boolean removed = this.hotRodEntity.requiredActionProviders != null && this.hotRodEntity.requiredActionProviders.removeIf(o -> Objects.equals(o.id, p0));
        this.hotRodEntity.updated |= removed;
        return removed;
    }

    public Set<MapRequiredActionProviderEntity> getRequiredActionProviders() {
        return this.hotRodEntity.requiredActionProviders == null ? null : HotRodTypesUtils.migrateSet(this.hotRodEntity.requiredActionProviders, collectionItem -> new HotRodRequiredActionProviderEntityDelegate((HotRodRequiredActionProviderEntity)collectionItem));
    }

    public Optional<MapRequiredActionProviderEntity> getRequiredActionProvider(String p0) {
        if (this.hotRodEntity.requiredActionProviders == null || this.hotRodEntity.requiredActionProviders.isEmpty()) {
            return Optional.empty();
        }
        return this.hotRodEntity.requiredActionProviders.stream().filter(o -> Objects.equals(o.id, p0)).findFirst().map(e -> new HotRodRequiredActionProviderEntityDelegate((HotRodRequiredActionProviderEntity)e));
    }

    public void addRequiredActionProvider(MapRequiredActionProviderEntity p0) {
        if (UndefinedValuesUtils.isUndefined((Object)(p0 = this.deepClone(p0)))) {
            return;
        }
        if (this.hotRodEntity.requiredActionProviders == null) {
            this.hotRodEntity.requiredActionProviders = new HashSet<HotRodRequiredActionProviderEntity>();
        }
        HotRodRequiredActionProviderEntity migrated = (HotRodRequiredActionProviderEntity)((HotRodEntityDelegate)p0).getHotRodEntity();
        this.hotRodEntity.updated |= this.hotRodEntity.requiredActionProviders.add(migrated);
    }

    public Set<MapRequiredCredentialEntity> getRequiredCredentials() {
        return this.hotRodEntity.requiredCredentials == null ? null : HotRodTypesUtils.migrateSet(this.hotRodEntity.requiredCredentials, collectionItem -> new HotRodRequiredCredentialEntityDelegate((HotRodRequiredCredentialEntity)collectionItem));
    }

    public void addRequiredCredential(MapRequiredCredentialEntity p0) {
        if (UndefinedValuesUtils.isUndefined((Object)(p0 = this.deepClone(p0)))) {
            return;
        }
        if (this.hotRodEntity.requiredCredentials == null) {
            this.hotRodEntity.requiredCredentials = new HashSet<HotRodRequiredCredentialEntity>();
        }
        HotRodRequiredCredentialEntity migrated = (HotRodRequiredCredentialEntity)((HotRodEntityDelegate)p0).getHotRodEntity();
        this.hotRodEntity.updated |= this.hotRodEntity.requiredCredentials.add(migrated);
    }

    public void setResetCredentialsFlow(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.resetCredentialsFlow, migrated);
        this.hotRodEntity.resetCredentialsFlow = migrated;
    }

    public String getResetCredentialsFlow() {
        return this.hotRodEntity.resetCredentialsFlow == null ? null : this.hotRodEntity.resetCredentialsFlow;
    }

    public void setResetPasswordAllowed(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.resetPasswordAllowed, migrated);
        this.hotRodEntity.resetPasswordAllowed = migrated;
    }

    public Boolean isResetPasswordAllowed() {
        return this.hotRodEntity.resetPasswordAllowed == null ? null : this.hotRodEntity.resetPasswordAllowed;
    }

    public void setRevokeRefreshToken(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.revokeRefreshToken, migrated);
        this.hotRodEntity.revokeRefreshToken = migrated;
    }

    public Boolean isRevokeRefreshToken() {
        return this.hotRodEntity.revokeRefreshToken == null ? null : this.hotRodEntity.revokeRefreshToken;
    }

    public void setSmtpConfig(Map<String, String> p0) {
        HashMap hashMap = p0 = p0 == null ? null : new HashMap(p0);
        if (p0 != null) {
            p0.values().removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        Set<HotRodPair> migrated = p0 == null ? null : HotRodTypesUtils.migrateMapToSet(p0, HotRodTypesUtils::createHotRodPairFromMapEntry);
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.smtpConfig, migrated);
        this.hotRodEntity.smtpConfig = migrated;
    }

    public Map<String, String> getSmtpConfig() {
        return this.hotRodEntity.smtpConfig == null ? null : HotRodTypesUtils.migrateSetToMap(this.hotRodEntity.smtpConfig, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public void setSslRequired(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.sslRequired, migrated);
        this.hotRodEntity.sslRequired = migrated;
    }

    public String getSslRequired() {
        return this.hotRodEntity.sslRequired == null ? null : this.hotRodEntity.sslRequired;
    }

    public Integer getSsoSessionIdleTimeout() {
        return this.hotRodEntity.ssoSessionIdleTimeout == null ? null : this.hotRodEntity.ssoSessionIdleTimeout;
    }

    public void setSsoSessionIdleTimeout(Integer p0) {
        Integer migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.ssoSessionIdleTimeout, migrated);
        this.hotRodEntity.ssoSessionIdleTimeout = migrated;
    }

    public void setSsoSessionIdleTimeoutRememberMe(Integer p0) {
        Integer migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.ssoSessionIdleTimeoutRememberMe, migrated);
        this.hotRodEntity.ssoSessionIdleTimeoutRememberMe = migrated;
    }

    public Integer getSsoSessionIdleTimeoutRememberMe() {
        return this.hotRodEntity.ssoSessionIdleTimeoutRememberMe == null ? null : this.hotRodEntity.ssoSessionIdleTimeoutRememberMe;
    }

    public void setSsoSessionMaxLifespan(Integer p0) {
        Integer migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.ssoSessionMaxLifespan, migrated);
        this.hotRodEntity.ssoSessionMaxLifespan = migrated;
    }

    public Integer getSsoSessionMaxLifespan() {
        return this.hotRodEntity.ssoSessionMaxLifespan == null ? null : this.hotRodEntity.ssoSessionMaxLifespan;
    }

    public Integer getSsoSessionMaxLifespanRememberMe() {
        return this.hotRodEntity.ssoSessionMaxLifespanRememberMe == null ? null : this.hotRodEntity.ssoSessionMaxLifespanRememberMe;
    }

    public void setSsoSessionMaxLifespanRememberMe(Integer p0) {
        Integer migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.ssoSessionMaxLifespanRememberMe, migrated);
        this.hotRodEntity.ssoSessionMaxLifespanRememberMe = migrated;
    }

    public void setSupportedLocales(Set<String> p0) {
        HashSet<String> hashSet = p0 = p0 == null ? null : new HashSet<String>(p0);
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        HashSet<String> migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.supportedLocales, migrated);
        this.hotRodEntity.supportedLocales = migrated;
    }

    public Set<String> getSupportedLocales() {
        return this.hotRodEntity.supportedLocales == null ? null : this.hotRodEntity.supportedLocales;
    }

    public void setVerifyEmail(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.verifyEmail, migrated);
        this.hotRodEntity.verifyEmail = migrated;
    }

    public Boolean isVerifyEmail() {
        return this.hotRodEntity.verifyEmail == null ? null : this.hotRodEntity.verifyEmail;
    }

    public void setWebAuthnPolicy(MapWebAuthnPolicyEntity p0) {
        HotRodWebAuthnPolicyEntity migrated = (p0 = this.deepClone(p0)) == null ? null : (HotRodWebAuthnPolicyEntity)((HotRodEntityDelegate)p0).getHotRodEntity();
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.webAuthnPolicy, migrated);
        this.hotRodEntity.webAuthnPolicy = migrated;
    }

    public MapWebAuthnPolicyEntity getWebAuthnPolicy() {
        return this.hotRodEntity.webAuthnPolicy == null ? null : new HotRodWebAuthnPolicyEntityDelegate(this.hotRodEntity.webAuthnPolicy);
    }

    public MapWebAuthnPolicyEntity getWebAuthnPolicyPasswordless() {
        return this.hotRodEntity.webAuthnPolicyPasswordless == null ? null : new HotRodWebAuthnPolicyEntityDelegate(this.hotRodEntity.webAuthnPolicyPasswordless);
    }

    public void setWebAuthnPolicyPasswordless(MapWebAuthnPolicyEntity p0) {
        HotRodWebAuthnPolicyEntity migrated = (p0 = this.deepClone(p0)) == null ? null : (HotRodWebAuthnPolicyEntity)((HotRodEntityDelegate)p0).getHotRodEntity();
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.webAuthnPolicyPasswordless, migrated);
        this.hotRodEntity.webAuthnPolicyPasswordless = migrated;
    }

    @Override
    public HotRodRealmEntity getHotRodEntity() {
        return this.hotRodEntity;
    }
}

