/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.management;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.BeanContainerListener;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.http.runtime.management.ManagementInterfaceBuildTimeConfig;
import io.quarkus.vertx.http.runtime.management.ManagementInterfaceConfiguration;
import io.quarkus.vertx.http.runtime.security.AbstractPathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.BasicAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.HttpSecurityRecorder;
import io.quarkus.vertx.http.runtime.security.ManagementInterfaceHttpAuthorizer;
import io.quarkus.vertx.http.runtime.security.ManagementPathMatchingHttpSecurityPolicy;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.function.Supplier;

@Recorder
public class ManagementInterfaceSecurityRecorder {
    final RuntimeValue<ManagementInterfaceConfiguration> httpConfiguration;
    final ManagementInterfaceBuildTimeConfig buildTimeConfig;

    public ManagementInterfaceSecurityRecorder(RuntimeValue<ManagementInterfaceConfiguration> httpConfiguration, ManagementInterfaceBuildTimeConfig buildTimeConfig) {
        this.httpConfiguration = httpConfiguration;
        this.buildTimeConfig = buildTimeConfig;
    }

    public Handler<RoutingContext> authenticationMechanismHandler(boolean proactiveAuthentication) {
        return new ManagementAuthenticationHandler(proactiveAuthentication);
    }

    public Handler<RoutingContext> permissionCheckHandler(ManagementInterfaceBuildTimeConfig buildTimeConfig, Map<String, Supplier<HttpSecurityPolicy>> policies) {
        return new Handler<RoutingContext>(){
            volatile ManagementInterfaceHttpAuthorizer authorizer;

            public void handle(RoutingContext event) {
                if (this.authorizer == null && this.authorizer == null) {
                    this.authorizer = (ManagementInterfaceHttpAuthorizer)CDI.current().select(ManagementInterfaceHttpAuthorizer.class, new Annotation[0]).get();
                }
                this.authorizer.checkPermission(event);
            }
        };
    }

    public BeanContainerListener initPermissions(final ManagementInterfaceBuildTimeConfig buildTimeConfig, final Map<String, Supplier<HttpSecurityPolicy>> policies) {
        return new BeanContainerListener(){

            public void created(BeanContainer container) {
                ((ManagementPathMatchingHttpSecurityPolicy)container.beanInstance(ManagementPathMatchingHttpSecurityPolicy.class, new Annotation[0])).init(buildTimeConfig.auth.permissions, policies, buildTimeConfig.rootPath);
            }
        };
    }

    public Supplier<?> setupBasicAuth() {
        return new Supplier<BasicAuthenticationMechanism>(){

            @Override
            public BasicAuthenticationMechanism get() {
                return new BasicAuthenticationMechanism(null, false);
            }
        };
    }

    static class ManagementAuthenticationHandler
    extends HttpSecurityRecorder.AbstractAuthenticationHandler {
        volatile ManagementPathMatchingHttpSecurityPolicy pathMatchingPolicy;

        public ManagementAuthenticationHandler(boolean proactiveAuthentication) {
            super(proactiveAuthentication);
        }

        @Override
        protected void setPathMatchingPolicy(RoutingContext event) {
            if (this.pathMatchingPolicy == null) {
                Instance pathMatchingPolicyInstance = CDI.current().select(ManagementPathMatchingHttpSecurityPolicy.class, new Annotation[0]);
                ManagementPathMatchingHttpSecurityPolicy managementPathMatchingHttpSecurityPolicy = this.pathMatchingPolicy = pathMatchingPolicyInstance.isResolvable() ? (ManagementPathMatchingHttpSecurityPolicy)pathMatchingPolicyInstance.get() : null;
            }
            if (this.pathMatchingPolicy != null) {
                event.put(AbstractPathMatchingHttpSecurityPolicy.class.getName(), (Object)this.pathMatchingPolicy);
            }
        }
    }
}

